/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.ResolvableType;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.annotation.RequestParam;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartFile;
import java.util.Map;

public class RequestParamMapMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        if (Map.class.isAssignableFrom(resolvable.getParameterType())) {
            RequestParam requestParam = resolvable.getParameterAnnotation(RequestParam.class);
            return requestParam != null && StringUtils.isBlank((String)requestParam.name());
        }
        return false;
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        ResolvableType resolvableType = resolvable.getResolvableType();
        if (MultiValueMap.class.isAssignableFrom(resolvable.getParameterType())) {
            Class valueType = resolvableType.as(MultiValueMap.class).getGeneric(new int[]{1}).resolve();
            if (valueType == MultipartFile.class) {
                return context.getMultipartRequest().getMultipartFiles();
            }
            if (valueType == Multipart.class) {
                return context.getMultipartRequest().multipartData();
            }
            return context.getParameters();
        }
        Class valueType = resolvableType.asMap().getGeneric(new int[]{1}).resolve();
        if (valueType == MultipartFile.class) {
            return context.getMultipartRequest().getFileMap();
        }
        if (valueType == Multipart.class) {
            return context.getMultipartRequest().multipartData().toSingleValueMap();
        }
        return context.getParameters().toSingleValueMap();
    }
}

