/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.core.MethodParameter;
import infra.http.HttpHeaders;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.annotation.RequestHeader;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.bind.resolver.MissingRequestHeaderException;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.Map;

public class RequestHeaderMethodArgumentResolver
extends AbstractNamedValueResolvingStrategy {
    public RequestHeaderMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && !parameter.isAssignableTo(Map.class);
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) throws Exception {
        HttpHeaders httpHeaders = context.requestHeaders();
        Object headerValues = httpHeaders.get(name);
        if (headerValues != null) {
            return headerValues.size() == 1 ? headerValues.get(0) : headerValues;
        }
        return null;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingRequestHeaderException(name, parameter);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) throws Exception {
        throw new MissingRequestHeaderException(name, parameter, true);
    }
}

