/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.http.HttpHeaders;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.annotation.RequestHeader;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.Map;

public class RequestHeaderMapMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.is(HttpHeaders.class) || resolvable.hasParameterAnnotation(RequestHeader.class) && resolvable.isAssignableTo(Map.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        HttpHeaders headers = context.getHeaders();
        Class<?> paramType = resolvable.getParameterType();
        if (paramType == HttpHeaders.class) {
            return headers;
        }
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            if (MultiValueMap.class == paramType) {
                return headers;
            }
            Map map = CollectionUtils.createMap(paramType, null, (int)headers.size());
            map.putAll(headers);
            return map;
        }
        Map singleValueMap = headers.toSingleValueMap();
        if (Map.class == paramType) {
            return singleValueMap;
        }
        Map map = CollectionUtils.createMap(paramType, null, (int)headers.size());
        map.putAll(singleValueMap);
        return map;
    }
}

