/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.io.InputStreamSource;
import infra.core.io.OutputStreamSource;
import infra.http.HttpMethod;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.multipart.MultipartRequest;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;

public class RequestContextMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        Class<?> paramType = resolvable.getParameterType();
        return RequestContext.class.isAssignableFrom(paramType) || MultipartRequest.class.isAssignableFrom(paramType) || InputStream.class.isAssignableFrom(paramType) || OutputStream.class.isAssignableFrom(paramType) || Reader.class.isAssignableFrom(paramType) || Writer.class.isAssignableFrom(paramType) || HttpMethod.class == paramType || Locale.class == paramType || TimeZone.class == paramType || InputStreamSource.class == paramType || OutputStreamSource.class == paramType || ZoneId.class == paramType;
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext request, ResolvableMethodParameter resolvable) throws Throwable {
        Class<?> paramType = resolvable.getParameterType();
        if (RequestContext.class.isAssignableFrom(paramType)) {
            if (paramType.isInstance(request)) {
                return request;
            }
            throw new IllegalStateException("Current request is not of type [%s]: %s".formatted(paramType.getName(), request));
        }
        if (MultipartRequest.class.isAssignableFrom(paramType)) {
            MultipartRequest multipartRequest = request.getMultipartRequest();
            if (paramType.isInstance(multipartRequest)) {
                return multipartRequest;
            }
            throw new IllegalStateException("Current multipart request is not of type [%s]: %s".formatted(paramType.getName(), multipartRequest));
        }
        if (InputStream.class.isAssignableFrom(paramType)) {
            InputStream inputStream = request.getInputStream();
            if (inputStream != null && !paramType.isInstance(inputStream)) {
                throw new IllegalStateException("Request input stream is not of type [%s]: %s".formatted(paramType.getName(), inputStream));
            }
            return inputStream;
        }
        if (OutputStream.class.isAssignableFrom(paramType)) {
            OutputStream outputStream = request.getOutputStream();
            if (outputStream != null && !paramType.isInstance(outputStream)) {
                throw new IllegalStateException("Response output stream is not of type [%s]: %s".formatted(paramType.getName(), outputStream));
            }
            return outputStream;
        }
        if (Reader.class.isAssignableFrom(paramType)) {
            BufferedReader reader = request.getReader();
            if (reader != null && !paramType.isInstance(reader)) {
                throw new IllegalStateException("Request body reader is not of type [%s]: %s".formatted(paramType.getName(), reader));
            }
            return reader;
        }
        if (Writer.class.isAssignableFrom(paramType)) {
            PrintWriter writer = request.getWriter();
            if (writer != null && !paramType.isInstance(writer)) {
                throw new IllegalStateException("Request body writer is not of type [%s]: %s".formatted(paramType.getName(), writer));
            }
            return writer;
        }
        if (HttpMethod.class == paramType) {
            return request.getMethod();
        }
        if (Locale.class == paramType) {
            return RequestContextUtils.getLocale(request);
        }
        if (TimeZone.class == paramType) {
            TimeZone timeZone = RequestContextUtils.getTimeZone(request);
            return timeZone != null ? timeZone : TimeZone.getDefault();
        }
        if (ZoneId.class == paramType) {
            TimeZone timeZone = RequestContextUtils.getTimeZone(request);
            return timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
        }
        if (InputStreamSource.class == paramType || OutputStreamSource.class == paramType) {
            return request;
        }
        throw new UnsupportedOperationException("Unknown parameter type: " + paramType.getName());
    }
}

