/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.core.MethodParameter;
import infra.core.TypeDescriptor;
import infra.core.conversion.ConversionService;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.annotation.PathVariable;
import infra.web.bind.MissingPathVariableException;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.method.support.UriComponentsContributor;
import infra.web.util.UriComponentsBuilder;
import java.util.Map;

public class PathVariableMethodArgumentResolver
extends AbstractNamedValueResolvingStrategy
implements UriComponentsContributor {
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);

    public PathVariableMethodArgumentResolver() {
    }

    public PathVariableMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory) {
        super(factory);
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        if (resolvable.hasParameterAnnotation(PathVariable.class)) {
            if (Map.class.isAssignableFrom(resolvable.getParameter().getParameterType())) {
                PathVariable pathVariable = resolvable.getParameterAnnotation(PathVariable.class);
                return pathVariable != null && StringUtils.hasText((String)pathVariable.value());
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) throws Exception {
        HandlerMatchingMetadata matchingMetadata = context.getMatchingMetadata();
        if (matchingMetadata != null) {
            return matchingMetadata.getUriVariable(name);
        }
        return null;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingPathVariableException(name, parameter);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) {
        throw new MissingPathVariableException(name, parameter, true);
    }

    @Override
    protected void handleResolvedValue(@Nullable Object arg, String name, ResolvableMethodParameter resolvable, RequestContext request) {
        request.matchingMetadata().getPathVariables().put(name, arg);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.supportsParameter(new ResolvableMethodParameter(parameter));
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        if (Map.class.isAssignableFrom(parameter.getParameterType())) {
            return;
        }
        PathVariable ann = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        String name = ann != null && StringUtils.isNotEmpty((CharSequence)ann.value()) ? ann.value() : parameter.getParameterName();
        String formatted = this.formatUriValue(conversionService, new TypeDescriptor(parameter), value);
        uriVariables.put(name, formatted);
    }

    @Nullable
    protected String formatUriValue(@Nullable ConversionService cs, @Nullable TypeDescriptor sourceType, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (cs != null) {
            return (String)cs.convert(value, sourceType, STRING_TYPE_DESCRIPTOR);
        }
        return value.toString();
    }
}

