/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.annotation.PathVariable;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.LinkedHashMap;
import java.util.Map;

public class PathVariableMapMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        PathVariable ann = resolvable.getParameterAnnotation(PathVariable.class);
        return ann != null && Map.class.isAssignableFrom(resolvable.getParameterType()) && StringUtils.isBlank((String)ann.value());
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        Map<String, String> uriVariables;
        HandlerMatchingMetadata metadata = context.getMatchingMetadata();
        if (metadata != null && CollectionUtils.isNotEmpty(uriVariables = metadata.getUriVariables())) {
            return new LinkedHashMap<String, String>(uriVariables);
        }
        return CollectionUtils.createMap(resolvable.getParameterType());
    }
}

