/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.ArraySizeTrimmer;
import infra.core.style.ToStringBuilder;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ParameterResolvingStrategies
implements ArraySizeTrimmer,
Iterable<ParameterResolvingStrategy>,
ParameterResolvingStrategy {
    private final ArrayList<ParameterResolvingStrategy> strategies;

    public ParameterResolvingStrategies() {
        this(new ArrayList<ParameterResolvingStrategy>());
    }

    public ParameterResolvingStrategies(int size) {
        this(new ArrayList<ParameterResolvingStrategy>(size));
    }

    ParameterResolvingStrategies(ArrayList<ParameterResolvingStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter parameter) {
        for (ParameterResolvingStrategy strategy : this.strategies) {
            if (!strategy.supportsParameter(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        for (ParameterResolvingStrategy strategy : this.strategies) {
            if (!strategy.supportsParameter(resolvable)) continue;
            return strategy.resolveArgument(context, resolvable);
        }
        return null;
    }

    public void add(@Nullable ParameterResolvingStrategy resolver) {
        if (resolver != null) {
            this.strategies.add(resolver);
        }
    }

    public void add(ParameterResolvingStrategy ... resolver) {
        CollectionUtils.addAll(this.strategies, (Object[])resolver);
    }

    public void add(@Nullable List<ParameterResolvingStrategy> resolvers) {
        if (CollectionUtils.isNotEmpty(resolvers)) {
            this.strategies.addAll(resolvers);
            this.trimToSize();
        }
    }

    public void set(@Nullable List<ParameterResolvingStrategy> resolver) {
        this.strategies.clear();
        if (CollectionUtils.isNotEmpty(resolver)) {
            this.strategies.addAll(resolver);
            this.trimToSize();
        }
    }

    @Nullable
    public <T> T get(Class<T> strategyClass) {
        int idx = this.indexOf(strategyClass);
        if (idx != -1) {
            return (T)this.strategies.get(idx);
        }
        return null;
    }

    public int indexOf(Class<?> strategyClass) {
        int idx = 0;
        for (ParameterResolvingStrategy resolver : this.strategies) {
            if (strategyClass == resolver.getClass()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int lastIndexOf(Class<?> strategyClass) {
        int idx = this.strategies.size() - 1;
        for (ParameterResolvingStrategy resolver : this.strategies) {
            if (strategyClass == resolver.getClass()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    public ParameterResolvingStrategy set(int idx, ParameterResolvingStrategy strategy) {
        return this.strategies.set(idx, strategy);
    }

    public boolean replace(Class<?> strategyClass, ParameterResolvingStrategy strategy) {
        int idx = this.indexOf(strategyClass);
        if (idx != -1) {
            this.strategies.set(idx, strategy);
            return true;
        }
        return false;
    }

    public boolean removeIf(Predicate<ParameterResolvingStrategy> filter) {
        return this.strategies.removeIf(filter);
    }

    public boolean contains(Class<?> strategyClass) {
        return this.indexOf(strategyClass) != -1;
    }

    public void trimToSize() {
        this.strategies.trimToSize();
    }

    public ArrayList<ParameterResolvingStrategy> getStrategies() {
        return this.strategies;
    }

    @Override
    public Iterator<ParameterResolvingStrategy> iterator() {
        return this.strategies.iterator();
    }

    @Override
    public void forEach(Consumer<? super ParameterResolvingStrategy> action) {
        this.strategies.forEach((Consumer<ParameterResolvingStrategy>)action);
    }

    @Override
    public Spliterator<ParameterResolvingStrategy> spliterator() {
        return this.strategies.spliterator();
    }

    public String toString() {
        return ToStringBuilder.from((Object)this).append("strategies", this.strategies.size()).toString();
    }

    public int size() {
        return this.strategies.size();
    }

    public boolean isEmpty() {
        return this.strategies.isEmpty();
    }
}

