/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.InitializingBean;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.support.DependencyInjectorProvider;
import infra.context.ApplicationContext;
import infra.context.support.ApplicationObjectSupport;
import infra.core.ArraySizeTrimmer;
import infra.core.MethodParameter;
import infra.core.style.ToStringBuilder;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.annotation.RequestAttribute;
import infra.web.bind.RequestBindingException;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.bind.resolver.AutowiredParameterResolver;
import infra.web.bind.resolver.CookieParameterResolver;
import infra.web.bind.resolver.ErrorsMethodArgumentResolver;
import infra.web.bind.resolver.ExpressionValueMethodArgumentResolver;
import infra.web.bind.resolver.HttpEntityMethodProcessor;
import infra.web.bind.resolver.MapMethodProcessor;
import infra.web.bind.resolver.MatrixVariableMapMethodArgumentResolver;
import infra.web.bind.resolver.MatrixVariableMethodArgumentResolver;
import infra.web.bind.resolver.ModelMethodProcessor;
import infra.web.bind.resolver.ParameterResolverNotFoundException;
import infra.web.bind.resolver.ParameterResolvingStrategies;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.bind.resolver.PathVariableMapMethodArgumentResolver;
import infra.web.bind.resolver.PathVariableMethodArgumentResolver;
import infra.web.bind.resolver.RequestContextMethodArgumentResolver;
import infra.web.bind.resolver.RequestHeaderMapMethodArgumentResolver;
import infra.web.bind.resolver.RequestHeaderMethodArgumentResolver;
import infra.web.bind.resolver.RequestParamMapMethodArgumentResolver;
import infra.web.bind.resolver.RequestParamMethodArgumentResolver;
import infra.web.bind.resolver.RequestPartMethodArgumentResolver;
import infra.web.bind.resolver.RequestResponseBodyMethodProcessor;
import infra.web.bind.resolver.UriComponentsBuilderParameterStrategy;
import infra.web.bind.resolver.date.DateParameterResolver;
import infra.web.bind.resolver.date.LocalDateParameterResolver;
import infra.web.bind.resolver.date.LocalDateTimeParameterResolver;
import infra.web.bind.resolver.date.LocalTimeParameterResolver;
import infra.web.handler.method.ModelAndViewMethodArgumentResolver;
import infra.web.handler.method.ModelAttributeMethodProcessor;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.ArrayList;
import java.util.List;

public class ParameterResolvingRegistry
extends ApplicationObjectSupport
implements ArraySizeTrimmer,
InitializingBean {
    private final ParameterResolvingStrategies defaultStrategies = new ParameterResolvingStrategies(36);
    private final ParameterResolvingStrategies customizedStrategies = new ParameterResolvingStrategies();
    @Nullable
    private RedirectModelManager redirectModelManager;
    private List<HttpMessageConverter<?>> messageConverters;
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private final ArrayList<Object> requestResponseBodyAdvice = new ArrayList();

    public ParameterResolvingRegistry() {
        this.messageConverters = new ArrayList(4);
        this.messageConverters.add(new ByteArrayHttpMessageConverter());
        this.messageConverters.add(new StringHttpMessageConverter());
        this.messageConverters.add(new AllEncompassingFormHttpMessageConverter());
    }

    public ParameterResolvingRegistry(List<HttpMessageConverter<?>> messageConverters) {
        this.setMessageConverters(messageConverters);
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public ParameterResolvingStrategies getDefaultStrategies() {
        return this.defaultStrategies;
    }

    public ParameterResolvingStrategies getCustomizedStrategies() {
        return this.customizedStrategies;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.defaultStrategies.isEmpty()) {
            this.registerDefaultStrategies();
        }
    }

    @Nullable
    protected ParameterResolvingStrategy lookupStrategy(ResolvableMethodParameter resolvable, Iterable<ParameterResolvingStrategy> strategies) {
        for (ParameterResolvingStrategy resolver : strategies) {
            if (!resolver.supportsParameter(resolvable)) continue;
            return resolver;
        }
        return null;
    }

    @Nullable
    public ParameterResolvingStrategy findStrategy(ResolvableMethodParameter parameter) {
        ParameterResolvingStrategy resolvingStrategy = this.lookupStrategy(parameter, this.customizedStrategies);
        if (resolvingStrategy == null) {
            resolvingStrategy = this.lookupStrategy(parameter, this.defaultStrategies);
        }
        return resolvingStrategy;
    }

    public ParameterResolvingStrategy obtainStrategy(ResolvableMethodParameter parameter) {
        ParameterResolvingStrategy resolver = this.findStrategy(parameter);
        if (resolver == null) {
            throw new ParameterResolverNotFoundException(parameter, "There isn't have a parameter resolver to resolve parameter: [%s] called: [%s] on %s".formatted(parameter.getParameterType(), parameter.getName(), parameter.getMethod()));
        }
        return resolver;
    }

    public void registerDefaultStrategies() {
        this.registerDefaultStrategies(this.defaultStrategies);
    }

    public void registerDefaultStrategies(ParameterResolvingStrategies strategies) {
        this.logger.debug("Registering default parameter-resolvers to {}", (Object)strategies);
        ApplicationContext context = this.obtainApplicationContext();
        ConfigurableBeanFactory beanFactory = (ConfigurableBeanFactory)context.unwrapFactory(ConfigurableBeanFactory.class);
        RedirectModelManager modelManager = this.getRedirectModelManager();
        if (modelManager == null) {
            this.logger.info("RedirectModel disabled");
        }
        strategies.add((ParameterResolvingStrategy)new RequestParamMethodArgumentResolver(beanFactory, false));
        strategies.add((ParameterResolvingStrategy)new RequestParamMapMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new PathVariableMethodArgumentResolver(beanFactory));
        strategies.add((ParameterResolvingStrategy)new PathVariableMapMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new MatrixVariableMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new MatrixVariableMapMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new ModelAttributeMethodProcessor(false));
        strategies.add((ParameterResolvingStrategy)new RequestResponseBodyMethodProcessor(this.getMessageConverters(), this.contentNegotiationManager, this.requestResponseBodyAdvice));
        strategies.add((ParameterResolvingStrategy)new RequestPartMethodArgumentResolver(this.getMessageConverters(), this.requestResponseBodyAdvice));
        strategies.add((ParameterResolvingStrategy)new RequestHeaderMethodArgumentResolver(beanFactory));
        strategies.add((ParameterResolvingStrategy)new RequestHeaderMapMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new ExpressionValueMethodArgumentResolver(beanFactory));
        strategies.add((ParameterResolvingStrategy)new RequestAttributeMethodArgumentResolver(beanFactory));
        strategies.add((ParameterResolvingStrategy)new AutowiredParameterResolver((DependencyInjectorProvider)context));
        CookieParameterResolver.register(strategies, beanFactory);
        strategies.add((ParameterResolvingStrategy)new RequestContextMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new ModelAndViewMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new ModelMethodProcessor());
        strategies.add((ParameterResolvingStrategy)new MapMethodProcessor());
        strategies.add((ParameterResolvingStrategy)new ErrorsMethodArgumentResolver());
        strategies.add((ParameterResolvingStrategy)new UriComponentsBuilderParameterStrategy());
        strategies.add((ParameterResolvingStrategy)new HttpEntityMethodProcessor(this.getMessageConverters(), this.contentNegotiationManager, this.requestResponseBodyAdvice, modelManager));
        strategies.add((ParameterResolvingStrategy)new DateParameterResolver());
        strategies.add((ParameterResolvingStrategy)new LocalDateParameterResolver());
        strategies.add((ParameterResolvingStrategy)new LocalTimeParameterResolver());
        strategies.add((ParameterResolvingStrategy)new LocalDateTimeParameterResolver());
        strategies.add((ParameterResolvingStrategy)new RequestParamMethodArgumentResolver(beanFactory, true));
        strategies.add((ParameterResolvingStrategy)new ModelAttributeMethodProcessor(true));
        strategies.trimToSize();
    }

    public boolean contains(Class<?> resolverClass) {
        return this.defaultStrategies.contains(resolverClass) || this.customizedStrategies.contains(resolverClass);
    }

    public void addCustomizedStrategies(ParameterResolvingStrategy ... strategies) {
        this.customizedStrategies.add(strategies);
    }

    public void addDefaultStrategies(ParameterResolvingStrategy ... strategies) {
        this.defaultStrategies.add(strategies);
    }

    public void setRedirectModelManager(@Nullable RedirectModelManager redirectModelManager) {
        this.redirectModelManager = redirectModelManager;
    }

    @Nullable
    public RedirectModelManager getRedirectModelManager() {
        return this.redirectModelManager;
    }

    public void addRequestResponseBodyAdvice(@Nullable List<Object> list) {
        CollectionUtils.addAll(this.requestResponseBodyAdvice, list);
    }

    public void setRequestResponseBodyAdvice(@Nullable List<Object> list) {
        this.requestResponseBodyAdvice.clear();
        CollectionUtils.addAll(this.requestResponseBodyAdvice, list);
    }

    public List<Object> getRequestResponseBodyAdvice() {
        return this.requestResponseBodyAdvice;
    }

    public void trimToSize() {
        this.defaultStrategies.trimToSize();
    }

    public String toString() {
        return ToStringBuilder.from((Object)((Object)this)).append("messageConverters", this.messageConverters).append("defaultStrategies", this.defaultStrategies.size()).append("customizedStrategies", this.customizedStrategies.size()).toString();
    }

    public static ParameterResolvingRegistry get(ApplicationContext context) {
        ParameterResolvingRegistry resolvingRegistry = (ParameterResolvingRegistry)((Object)BeanFactoryUtils.find((BeanFactory)context, ParameterResolvingRegistry.class));
        if (resolvingRegistry == null) {
            resolvingRegistry = new ParameterResolvingRegistry();
            resolvingRegistry.setApplicationContext(context);
            resolvingRegistry.registerDefaultStrategies();
        }
        return resolvingRegistry;
    }

    static final class RequestAttributeMethodArgumentResolver
    extends AbstractNamedValueResolvingStrategy {
        RequestAttributeMethodArgumentResolver(ConfigurableBeanFactory beanFactory) {
            super(beanFactory);
        }

        @Override
        public boolean supportsParameter(ResolvableMethodParameter resolvable) {
            return resolvable.hasParameterAnnotation(RequestAttribute.class);
        }

        @Override
        @Nullable
        protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) {
            return context.getAttribute(name);
        }

        @Override
        protected void handleMissingValue(String name, MethodParameter parameter) {
            throw new RequestBindingException("Missing request attribute '%s' of type %s".formatted(name, parameter.getNestedParameterType().getSimpleName()));
        }
    }
}

