/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartFile;
import java.util.Collection;
import java.util.List;

final class MultipartResolutionDelegate {
    public static final Object UNRESOLVABLE = new Object();

    MultipartResolutionDelegate() {
    }

    public static boolean isMultipartArgument(MethodParameter parameter) {
        Class paramType = parameter.getNestedParameterType();
        return Multipart.class.isAssignableFrom(paramType) || MultipartResolutionDelegate.isMultipartCollection(parameter, paramType) || MultipartResolutionDelegate.isMultipartArray(paramType);
    }

    @Nullable
    public static Object resolveMultipartArgument(String name, MethodParameter parameter, RequestContext request) {
        if (!request.isMultipart()) {
            if (MultipartResolutionDelegate.isMultipartArgument(parameter)) {
                return null;
            }
            return UNRESOLVABLE;
        }
        Class parameterType = parameter.getNestedParameterType();
        if (Multipart.class.isAssignableFrom(parameterType)) {
            return CollectionUtils.firstElement(request.getMultipartRequest().multipartData(name));
        }
        if (MultipartResolutionDelegate.isMultipartCollection(parameter, parameterType)) {
            return request.getMultipartRequest().multipartData(name);
        }
        if (MultipartResolutionDelegate.isMultipartArray(parameterType)) {
            List<Multipart> parts = request.getMultipartRequest().multipartData(name);
            if (parts == null) {
                return null;
            }
            if (parameterType.getComponentType() == MultipartFile.class) {
                return parts.toArray(new MultipartFile[parts.size()]);
            }
            return parts.toArray(new Multipart[parts.size()]);
        }
        return UNRESOLVABLE;
    }

    private static boolean isMultipartCollection(MethodParameter methodParam, Class<?> parameterType) {
        return (parameterType = MultipartResolutionDelegate.getCollectionParameterType(methodParam, parameterType)) != null && Multipart.class.isAssignableFrom(parameterType);
    }

    private static boolean isMultipartArray(Class<?> parameterType) {
        Class<?> componentType = parameterType.getComponentType();
        return componentType != null && Multipart.class.isAssignableFrom(componentType);
    }

    @Nullable
    private static Class<?> getCollectionParameterType(MethodParameter methodParam, Class<?> paramType) {
        if (Collection.class == paramType || List.class.isAssignableFrom(paramType)) {
            return ResolvableType.forMethodParameter((MethodParameter)methodParam).asCollection().resolveGeneric(new int[0]);
        }
        return null;
    }
}

