/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.lang.Nullable;
import infra.ui.Model;
import infra.web.BindingContext;
import infra.web.RedirectModel;
import infra.web.RequestContext;
import infra.web.ReturnValueHandler;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.Map;

public class ModelMethodProcessor
implements ReturnValueHandler,
ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.isAssignableTo(Model.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        if (resolvable.is(RedirectModel.class)) {
            RedirectModel redirectModel = new RedirectModel();
            context.setAttribute(RedirectModel.OUTPUT_ATTRIBUTE, redirectModel);
            context.binding().setRedirectModel(redirectModel);
            return redirectModel;
        }
        return context.binding().getModel();
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof Model;
    }

    @Override
    public boolean supportsHandler(Object handler) {
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            return handlerMethod.isReturnTypeAssignableTo(Model.class);
        }
        return false;
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        HandlerMethod handlerMethod;
        if (returnValue instanceof Model) {
            Model model = (Model)returnValue;
            BindingContext bindingContext = context.binding();
            if (returnValue instanceof RedirectModel) {
                RedirectModel redirectModel = (RedirectModel)returnValue;
                RedirectModel existRedirectModel = bindingContext.getRedirectModel();
                if (existRedirectModel != null) {
                    existRedirectModel.addAllAttributes((Map)((Object)redirectModel));
                } else {
                    context.setAttribute(RedirectModel.OUTPUT_ATTRIBUTE, redirectModel);
                    bindingContext.setRedirectModel(redirectModel);
                }
            } else {
                bindingContext.addAllAttributes(model.asMap());
            }
        } else if (returnValue != null && (handlerMethod = HandlerMethod.unwrap(handler)) != null) {
            throw new UnsupportedOperationException("Unexpected return type [%s] in method: %s".formatted(handlerMethod.getReturnType().getParameterType().getName(), handlerMethod.getMethod()));
        }
    }
}

