/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.web.bind.MissingRequestValueException;

public class MissingRequestHeaderException
extends MissingRequestValueException {
    private final String headerName;
    private final MethodParameter parameter;

    public MissingRequestHeaderException(String headerName, MethodParameter parameter) {
        this(headerName, parameter, false);
    }

    public MissingRequestHeaderException(String headerName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{headerName});
        this.headerName = headerName;
        this.parameter = parameter;
        this.getBody().setDetail("Required header '%s' is not present.".formatted(this.headerName));
    }

    public String getMessage() {
        String typeName = this.parameter.getNestedParameterType().getSimpleName();
        return "Required request header '%s' for method parameter type %s is %s".formatted(this.headerName, typeName, this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getHeaderName() {
        return this.headerName;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }
}

