/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.web.bind.MissingRequestValueException;

public class MissingRequestCookieException
extends MissingRequestValueException {
    private final String cookieName;
    private final MethodParameter parameter;

    public MissingRequestCookieException(String cookieName, MethodParameter parameter) {
        this(cookieName, parameter, false);
    }

    public MissingRequestCookieException(String cookieName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{cookieName});
        this.cookieName = cookieName;
        this.parameter = parameter;
        this.getBody().setDetail("Required cookie '%s' is not present.".formatted(this.cookieName));
    }

    public String getMessage() {
        return "Required cookie '%s' for method parameter type %s is %s".formatted(this.cookieName, this.parameter.getNestedParameterType().getSimpleName(), this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getCookieName() {
        return this.cookieName;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }
}

