/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.annotation.MatrixVariable;
import infra.web.bind.MissingMatrixVariableException;
import infra.web.bind.RequestBindingException;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MatrixVariableMethodArgumentResolver
extends AbstractNamedValueResolvingStrategy {
    public MatrixVariableMethodArgumentResolver() {
        super(null);
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        if (!resolvable.hasParameterAnnotation(MatrixVariable.class)) {
            return false;
        }
        if (Map.class.isAssignableFrom(resolvable.getParameterType())) {
            MatrixVariable matrixVariable = resolvable.getParameterAnnotation(MatrixVariable.class);
            return matrixVariable != null && StringUtils.hasText((String)matrixVariable.name());
        }
        return true;
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext request) throws Exception {
        Map<String, MultiValueMap<String, String>> pathParameters = request.matchingMetadata().getMatrixVariables();
        if (CollectionUtils.isEmpty(pathParameters)) {
            return null;
        }
        MethodParameter parameter = resolvable.getParameter();
        MatrixVariable ann = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No MatrixVariable annotation");
        String pathVar = ann.pathVar();
        List paramValues = null;
        if (!pathVar.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            if (pathParameters.containsKey(pathVar)) {
                paramValues = (List)pathParameters.get(pathVar).get((Object)name);
            }
        } else {
            boolean found = false;
            paramValues = new ArrayList();
            for (MultiValueMap<String, String> params : pathParameters.values()) {
                if (!params.containsKey((Object)name)) continue;
                if (found) {
                    String paramType = parameter.getNestedParameterType().getName();
                    throw new RequestBindingException("Found more than one match for URI path parameter '%s' for parameter type [%s]. Use 'pathVar' attribute to disambiguate.".formatted(name, paramType));
                }
                paramValues.addAll((Collection)params.get((Object)name));
                found = true;
            }
        }
        if (CollectionUtils.isEmpty(paramValues)) {
            return null;
        }
        if (paramValues.size() == 1) {
            return paramValues.get(0);
        }
        return paramValues;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) throws RequestBindingException {
        throw new MissingMatrixVariableException(name, parameter);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) throws Exception {
        throw new MissingMatrixVariableException(name, parameter, true);
    }
}

