/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.annotation.MatrixVariable;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.List;
import java.util.Map;

public class MatrixVariableMapMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        MatrixVariable variable = resolvable.getParameterAnnotation(MatrixVariable.class);
        return variable != null && Map.class.isAssignableFrom(resolvable.getParameterType()) && StringUtils.isBlank((String)variable.name());
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        Map<String, MultiValueMap<String, String>> matrixVariables = context.matchingMetadata().getMatrixVariables();
        MethodParameter parameter = resolvable.getParameter();
        MultiValueMap<String, String> map = this.mapMatrixVariables(parameter, matrixVariables);
        return this.isSingleValueMap(parameter) ? map.toSingleValueMap() : map;
    }

    private MultiValueMap<String, String> mapMatrixVariables(MethodParameter parameter, @Nullable Map<String, MultiValueMap<String, String>> matrixVariables) {
        LinkedMultiValueMap map = MultiValueMap.forLinkedHashMap();
        if (CollectionUtils.isEmpty(matrixVariables)) {
            return map;
        }
        MatrixVariable ann = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No MatrixVariable annotation");
        String pathVariable = ann.pathVar();
        if (!pathVariable.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            MultiValueMap<String, String> mapForPathVariable = matrixVariables.get(pathVariable);
            if (mapForPathVariable == null) {
                return map;
            }
            map.putAll(mapForPathVariable);
        } else {
            for (MultiValueMap<String, String> vars : matrixVariables.values()) {
                for (Map.Entry entry : vars.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    for (String value : values) {
                        map.add((Object)name, (Object)value);
                    }
                }
            }
        }
        return map;
    }

    private boolean isSingleValueMap(MethodParameter parameter) {
        ResolvableType[] genericTypes;
        if (!MultiValueMap.class.isAssignableFrom(parameter.getParameterType()) && (genericTypes = ResolvableType.forMethodParameter((MethodParameter)parameter).getGenerics()).length == 2) {
            return !List.class.isAssignableFrom(genericTypes[1].toClass());
        }
        return false;
    }
}

