/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.ResolvableType;
import infra.lang.Nullable;
import infra.web.BindingContext;
import infra.web.RequestContext;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.util.Map;

public class MapMethodProcessor
implements ParameterResolvingStrategy,
HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        if (resolvable.getParameterType() == Map.class && resolvable.getParameterAnnotations().length == 0) {
            ResolvableType mapType = resolvable.getResolvableType().asMap();
            ResolvableType keyType = mapType.getGeneric(new int[]{0});
            ResolvableType valueType = mapType.getGeneric(new int[]{1});
            return keyType.resolve() == String.class && valueType.resolve() == Object.class;
        }
        return false;
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        return context.binding().getModel();
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isReturnTypeAssignableTo(Map.class);
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof Map;
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        HandlerMethod handlerMethod;
        if (returnValue instanceof Map) {
            Map map = (Map)returnValue;
            BindingContext bindingContext = context.getBinding();
            if (bindingContext != null) {
                bindingContext.addAllAttributes(map);
            }
        } else if (returnValue != null && (handlerMethod = HandlerMethod.unwrap(handler)) != null) {
            throw new UnsupportedOperationException("Unexpected return type [%s] in method: %s".formatted(handlerMethod.getReturnType().getParameterType().getName(), handlerMethod.getMethod()));
        }
    }
}

