/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.http.RequestEntity;
import infra.http.ResponseEntity;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.ErrorResponse;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.accept.ContentNegotiationManager;
import infra.web.bind.resolver.AbstractMessageConverterMethodProcessor;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpEntityMethodProcessor
extends AbstractMessageConverterMethodProcessor
implements HandlerMethodReturnValueHandler {
    @Nullable
    private final RedirectModelManager redirectModelManager;

    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable RedirectModelManager redirectModelManager) {
        super(converters);
        this.redirectModelManager = redirectModelManager;
    }

    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable List<Object> requestResponseBodyAdvice, @Nullable RedirectModelManager redirectModelManager) {
        super(converters, null, requestResponseBodyAdvice);
        this.redirectModelManager = redirectModelManager;
    }

    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice, @Nullable RedirectModelManager redirectModelManager) {
        super(converters, manager, requestResponseBodyAdvice);
        this.redirectModelManager = redirectModelManager;
    }

    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice, @Nullable RedirectModelManager redirectModelManager, List<ErrorResponse.Interceptor> interceptors) {
        super(converters, manager, requestResponseBodyAdvice, interceptors);
        this.redirectModelManager = redirectModelManager;
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.is(HttpEntity.class) || resolvable.is(RequestEntity.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws IOException, HttpMediaTypeNotSupportedException {
        MethodParameter parameter = resolvable.getParameter();
        Type paramType = this.getHttpEntityType(parameter);
        if (paramType == null) {
            throw new IllegalArgumentException("HttpEntity parameter '%s' in method %s is not parameterized".formatted(parameter.getParameterName(), parameter.getMethod()));
        }
        Object body = this.readWithMessageConverters(context, parameter, paramType);
        if (RequestEntity.class == parameter.getParameterType()) {
            return new RequestEntity<Object>(body, context.requestHeaders(), context.getMethod(), context.getURI());
        }
        return new HttpEntity<Object>(body, context.requestHeaders());
    }

    @Nullable
    private Type getHttpEntityType(MethodParameter parameter) {
        Assert.isAssignable(HttpEntity.class, (Class)parameter.getParameterType());
        Type parameterType = parameter.getGenericParameterType();
        if (parameterType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parameterType;
            if (type.getActualTypeArguments().length != 1) {
                throw new IllegalArgumentException("Expected single generic parameter on '%s' in method %s".formatted(parameter.getParameterName(), parameter.getMethod()));
            }
            return type.getActualTypeArguments()[0];
        }
        if (parameterType instanceof Class) {
            return Object.class;
        }
        return null;
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof HttpEntity && !(returnValue instanceof RequestEntity);
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handlerMethod) {
        MethodParameter returnType = handlerMethod.getReturnType();
        Class type = returnType.getParameterType();
        return HttpEntity.class.isAssignableFrom(type) && !RequestEntity.class.isAssignableFrom(type) || ErrorResponse.class.isAssignableFrom(type) || ProblemDetail.class.isAssignableFrom(type);
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        HandlerMethod handlerMethod;
        HttpHeaders entityHeaders;
        ResponseEntity<Object> responseEntity;
        ProblemDetail detail;
        ResponseEntity<Object> httpEntity;
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof ErrorResponse) {
            ErrorResponse response = (ErrorResponse)returnValue;
            httpEntity = new ResponseEntity<ProblemDetail>(response.getBody(), (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode());
        } else if (returnValue instanceof ProblemDetail) {
            detail = (ProblemDetail)returnValue;
            httpEntity = ResponseEntity.of(detail).build();
        } else {
            Assert.isInstanceOf(HttpEntity.class, (Object)returnValue);
            httpEntity = (ResponseEntity)returnValue;
        }
        Object body = httpEntity.getBody();
        if (body instanceof ProblemDetail) {
            ErrorResponse response;
            Object handlerMethod2;
            detail = (ProblemDetail)body;
            if (detail.getInstance() == null) {
                URI path = URI.create(context.getRequestURI());
                detail.setInstance(path);
            }
            if (this.logger.isWarnEnabled() && httpEntity instanceof ResponseEntity && (responseEntity = httpEntity).getStatusCode().value() != detail.getStatus() && (handlerMethod2 = HandlerMethod.unwrap(handler)) != null) {
                this.logger.warn("%s returned ResponseEntity: %s, but its status doesn't match the ProblemDetail status: %d".formatted(((HandlerMethod)handlerMethod2).getMethod().toGenericString(), responseEntity, detail.getStatus()));
            }
            this.invokeErrorResponseInterceptors(detail, returnValue instanceof ErrorResponse ? (response = (ErrorResponse)returnValue) : null);
        }
        if (!(entityHeaders = httpEntity.getHeaders()).isEmpty()) {
            HttpHeaders outputHeaders = context.responseHeaders();
            for (Map.Entry entry : entityHeaders.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if ("Vary".equals(key) && outputHeaders.containsKey("Vary")) {
                    List<String> values = this.getVaryRequestHeadersToAdd(outputHeaders, entityHeaders);
                    if (values.isEmpty()) continue;
                    outputHeaders.setVary(values);
                    continue;
                }
                outputHeaders.put(key, value);
            }
        }
        if (httpEntity instanceof ResponseEntity) {
            String location;
            responseEntity = httpEntity;
            HttpStatusCode returnStatus = responseEntity.getStatusCode();
            context.setStatus(returnStatus);
            if (returnStatus.is2xxSuccessful()) {
                HttpMethod method = context.getMethod();
                if ((HttpMethod.GET == method || HttpMethod.HEAD == method) && this.isResourceNotModified(context, method)) {
                    return;
                }
            } else if (returnStatus.is3xxRedirection() && (location = context.responseHeaders().getFirst("Location")) != null) {
                this.saveRedirectAttributes(context, location);
            }
        }
        if ((handlerMethod = HandlerMethod.unwrap(handler)) != null) {
            MethodParameter methodReturnType = handlerMethod.getReturnType();
            this.writeWithMessageConverters(body, methodReturnType, context);
        } else if (body != null) {
            this.writeWithMessageConverters(body, null, context);
        }
    }

    private List<String> getVaryRequestHeadersToAdd(HttpHeaders responseHeaders, HttpHeaders entityHeaders) {
        List<String> entityHeadersVary = entityHeaders.getVary();
        Object vary = responseHeaders.get("Vary");
        if (vary != null) {
            ArrayList<String> result = new ArrayList<String>(entityHeadersVary);
            Iterator iterator = vary.iterator();
            while (iterator.hasNext()) {
                String header = (String)iterator.next();
                for (String existing : StringUtils.tokenizeToStringArray((String)header, (String)",")) {
                    if ("*".equals(existing)) {
                        return Collections.emptyList();
                    }
                    for (String value : entityHeadersVary) {
                        if (!value.equalsIgnoreCase(existing)) continue;
                        result.remove(value);
                    }
                }
            }
            return result;
        }
        return entityHeadersVary;
    }

    private boolean isResourceNotModified(RequestContext context, HttpMethod method) {
        HttpHeaders responseHeaders = context.responseHeaders();
        String etag = responseHeaders.getETag();
        long lastModifiedTimestamp = responseHeaders.getLastModified();
        if (HttpMethod.GET == method || HttpMethod.HEAD == method) {
            responseHeaders.remove("ETag");
            responseHeaders.remove("Last-Modified");
        }
        return context.checkNotModified(etag, lastModifiedTimestamp);
    }

    private void saveRedirectAttributes(RequestContext request, String location) {
        RequestContextUtils.saveRedirectModel(location, request, this.redirectModelManager);
    }

    @Override
    protected Class<?> getReturnValueType(@Nullable Object returnValue, @Nullable MethodParameter returnType) {
        if (returnValue != null) {
            return returnValue.getClass();
        }
        if (returnType != null) {
            Object type = this.getHttpEntityType(returnType);
            if (type == null) {
                type = Object.class;
            }
            return ResolvableType.forMethodParameter((MethodParameter)returnType, (Type)type).toClass();
        }
        throw new IllegalStateException("return-value and return-type must not be null at same time");
    }
}

