/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.lang.Nullable;
import infra.ui.ModelMap;
import infra.util.CollectionUtils;
import infra.validation.BindingResult;
import infra.validation.Errors;
import infra.web.RequestContext;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import java.util.Set;

public class ErrorsMethodArgumentResolver
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.isAssignableTo(Errors.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        ModelMap model = context.binding().getModel();
        String lastKey = (String)CollectionUtils.lastElement((Set)model.keySet());
        if (lastKey != null && lastKey.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return model.getAttribute(lastKey);
        }
        throw new IllegalStateException("An Errors/BindingResult argument is expected to be declared immediately after the model attribute, the @RequestBody or the @RequestPart arguments to which they apply: " + resolvable.getMethod());
    }
}

