/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.core.MethodParameter;
import infra.http.HttpCookie;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.annotation.CookieValue;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.bind.resolver.MissingRequestCookieException;
import infra.web.bind.resolver.ParameterResolvingStrategies;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;

public class CookieParameterResolver
extends AbstractNamedValueResolvingStrategy
implements ParameterResolvingStrategy {
    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.is(HttpCookie.class);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingRequestCookieException(name, parameter);
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) throws Exception {
        return context.getCookie(name);
    }

    public static void register(ParameterResolvingStrategies resolvers, ConfigurableBeanFactory beanFactory) {
        resolvers.add(new CookieParameterResolver(), new AllCookieParameterResolver(), new CookieValueAnnotationParameterResolver(beanFactory), new CookieCollectionParameterResolver(beanFactory));
    }

    private static class AllCookieParameterResolver
    implements ParameterResolvingStrategy {
        private AllCookieParameterResolver() {
        }

        @Override
        public boolean supportsParameter(ResolvableMethodParameter resolvable) {
            Class<?> parameterType = resolvable.getParameterType();
            return parameterType.isArray() && parameterType.getComponentType() == HttpCookie.class;
        }

        @Override
        public Object resolveArgument(RequestContext requestContext, ResolvableMethodParameter resolvable) {
            return requestContext.getCookies();
        }
    }

    private static class CookieValueAnnotationParameterResolver
    extends AbstractNamedValueResolvingStrategy {
        public CookieValueAnnotationParameterResolver(@Nullable ConfigurableBeanFactory beanFactory) {
            super(beanFactory);
        }

        @Override
        public boolean supportsParameter(ResolvableMethodParameter resolvable) {
            return resolvable.hasParameterAnnotation(CookieValue.class);
        }

        @Override
        protected void handleMissingValue(String name, MethodParameter parameter) {
            throw new MissingRequestCookieException(name, parameter);
        }

        @Override
        protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) {
            throw new MissingRequestCookieException(name, parameter, true);
        }

        @Override
        @Nullable
        protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) {
            HttpCookie cookie = context.getCookie(name);
            if (cookie != null) {
                if (resolvable.is(HttpCookie.class)) {
                    return cookie;
                }
                return cookie.getValue();
            }
            return null;
        }
    }

    private static class CookieCollectionParameterResolver
    extends AbstractNamedValueResolvingStrategy {
        public CookieCollectionParameterResolver(ConfigurableBeanFactory beanFactory) {
            super(beanFactory);
        }

        @Override
        public boolean supportsParameter(ResolvableMethodParameter resolvable) {
            return resolvable.isCollection() && resolvable.getResolvableType().getGeneric(new int[]{0}).resolve() == HttpCookie.class;
        }

        @Override
        @Nullable
        protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) throws Exception {
            return context.getCookies();
        }
    }
}

