/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.factory.annotation.Autowired;
import infra.beans.factory.config.DependencyDescriptor;
import infra.beans.factory.support.DependencyInjector;
import infra.beans.factory.support.DependencyInjectorProvider;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;

public class AutowiredParameterResolver
implements ParameterResolvingStrategy {
    private final DependencyInjector injector;

    public AutowiredParameterResolver(DependencyInjectorProvider provider) {
        this.injector = provider.getInjector();
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.hasParameterAnnotation(Autowired.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        return this.injector.resolveValue(new DependencyDescriptor(resolvable.getParameter(), true));
    }
}

