/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.ConversionNotSupportedException;
import infra.beans.TypeMismatchException;
import infra.beans.factory.config.BeanExpressionContext;
import infra.beans.factory.config.BeanExpressionResolver;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.config.Scope;
import infra.core.MethodParameter;
import infra.lang.Nullable;
import infra.web.BindingContext;
import infra.web.RequestContext;
import infra.web.bind.MissingRequestValueException;
import infra.web.bind.WebDataBinder;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.context.support.RequestScope;
import infra.web.handler.method.MethodArgumentConversionNotSupportedException;
import infra.web.handler.method.MethodArgumentTypeMismatchException;
import infra.web.handler.method.NamedValueInfo;
import infra.web.handler.method.ResolvableMethodParameter;

public abstract class AbstractNamedValueResolvingStrategy
implements ParameterResolvingStrategy {
    @Nullable
    private final ConfigurableBeanFactory configurableBeanFactory;
    @Nullable
    private final BeanExpressionContext expressionContext;

    public AbstractNamedValueResolvingStrategy() {
        this.configurableBeanFactory = null;
        this.expressionContext = null;
    }

    public AbstractNamedValueResolvingStrategy(@Nullable ConfigurableBeanFactory beanFactory) {
        this.configurableBeanFactory = beanFactory;
        this.expressionContext = beanFactory != null ? new BeanExpressionContext(beanFactory, (Scope)RequestScope.instance) : null;
    }

    @Override
    @Nullable
    public final Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        Object arg;
        MethodParameter methodParameter = resolvable.getParameter();
        NamedValueInfo namedValueInfo = this.getNamedValueInfo(resolvable);
        if (namedValueInfo.nameEmbedded) {
            Object resolvedName = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.name);
            if (resolvedName == null) {
                throw new IllegalArgumentException("Specified name must not resolve to null: [%s]".formatted(namedValueInfo.name));
            }
            arg = this.resolveName(resolvedName.toString(), resolvable, context);
        } else {
            arg = this.resolveName(namedValueInfo.name, resolvable, context);
        }
        if (arg == null) {
            if (namedValueInfo.defaultValue != null) {
                arg = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
            } else if (namedValueInfo.required && !methodParameter.isNullable()) {
                this.handleMissingValue(namedValueInfo.name, methodParameter, context);
            }
            arg = this.handleNullValue(namedValueInfo.name, arg, methodParameter.getParameterType());
        } else if ("".equals(arg) && namedValueInfo.defaultValue != null) {
            arg = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
        }
        BindingContext bindingContext = context.getBinding();
        if (bindingContext != null && (arg = AbstractNamedValueResolvingStrategy.convertIfNecessary(context, bindingContext, namedValueInfo, methodParameter, arg)) == null) {
            if (namedValueInfo.defaultValue != null) {
                arg = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
                arg = AbstractNamedValueResolvingStrategy.convertIfNecessary(context, bindingContext, namedValueInfo, methodParameter, arg);
            } else if (namedValueInfo.required && !methodParameter.isNullable()) {
                this.handleMissingValueAfterConversion(namedValueInfo.name, methodParameter, context);
            }
        }
        this.handleResolvedValue(arg, namedValueInfo.name, resolvable, context);
        return arg;
    }

    @Nullable
    private static Object convertIfNecessary(RequestContext context, BindingContext bindingContext, NamedValueInfo namedValueInfo, MethodParameter methodParameter, @Nullable Object arg) throws Throwable {
        WebDataBinder binder = bindingContext.createBinder(context, namedValueInfo.name);
        try {
            arg = binder.convertIfNecessary(arg, methodParameter.getParameterType(), methodParameter);
        }
        catch (ConversionNotSupportedException ex) {
            throw new MethodArgumentConversionNotSupportedException(arg, ex.getRequiredType(), namedValueInfo.name, methodParameter, ex.getCause());
        }
        catch (TypeMismatchException ex) {
            throw new MethodArgumentTypeMismatchException(arg, ex.getRequiredType(), namedValueInfo.name, methodParameter, ex.getCause());
        }
        return arg;
    }

    protected NamedValueInfo getNamedValueInfo(ResolvableMethodParameter resolvable) {
        return resolvable.getNamedValueInfo();
    }

    @Nullable
    private Object resolveEmbeddedValuesAndExpressions(String value) {
        if (this.configurableBeanFactory == null || this.expressionContext == null) {
            return value;
        }
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(value);
        BeanExpressionResolver exprResolver = this.configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return value;
        }
        return exprResolver.evaluate(placeholdersResolved, this.expressionContext);
    }

    @Nullable
    protected abstract Object resolveName(String var1, ResolvableMethodParameter var2, RequestContext var3) throws Exception;

    protected void handleMissingValue(String name, MethodParameter parameter, RequestContext request) throws Exception {
        this.handleMissingValue(name, parameter);
    }

    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingRequestValueException("Missing argument '%s' for method parameter of type %s".formatted(name, parameter.getNestedParameterType().getSimpleName()));
    }

    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) throws Exception {
        throw new MissingRequestValueException("Missing argument '%s' for method parameter of type %s".formatted(name, parameter.getParameterType().getSimpleName()), true);
    }

    @Nullable
    private Object handleNullValue(String name, @Nullable Object value, Class<?> paramType) {
        if (value == null) {
            if (Boolean.TYPE.equals(paramType)) {
                return Boolean.FALSE;
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional %s parameter '%s' is present but cannot be translated into a null value due to being declared as a primitive type. Consider declaring it as object wrapper for the corresponding primitive type.".formatted(paramType.getSimpleName(), name));
            }
        }
        return value;
    }

    protected void handleResolvedValue(@Nullable Object arg, String name, ResolvableMethodParameter resolvable, RequestContext context) {
    }
}

