/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.GenericTypeResolver;
import infra.core.MethodParameter;
import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.core.io.InputStreamResource;
import infra.core.io.Resource;
import infra.core.io.ResourceRegion;
import infra.http.HttpEntity;
import infra.http.HttpRange;
import infra.http.HttpStatus;
import infra.http.MediaType;
import infra.http.ProblemDetail;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.CollectionUtils;
import infra.util.LogFormatUtils;
import infra.util.MimeTypeUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.ErrorResponse;
import infra.web.HandlerMatchingMetadata;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.ReturnValueHandler;
import infra.web.accept.ContentNegotiationManager;
import infra.web.bind.resolver.AbstractMessageConverterMethodArgumentResolver;
import infra.web.bind.resolver.RequestResponseBodyAdviceChain;
import infra.web.util.UriUtils;
import infra.web.util.pattern.PathPattern;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractMessageConverterMethodProcessor
extends AbstractMessageConverterMethodArgumentResolver
implements ReturnValueHandler {
    private static final Set<String> SAFE_EXTENSIONS = Set.of("txt", "text", "yml", "properties", "csv", "json", "xml", "atom", "rss", "png", "jpe", "jpeg", "jpg", "gif", "wbmp", "bmp");
    private static final Set<String> SAFE_MEDIA_BASE_TYPES = Set.of("audio", "image", "video");
    private static final List<MediaType> ALL_APPLICATION_MEDIA_TYPES = List.of(MediaType.ALL, new MediaType("application"));
    private static final Type RESOURCE_REGION_LIST_TYPE = new ParameterizedTypeReference<List<ResourceRegion>>(){}.getType();
    private static final List<MediaType> problemMediaTypes = Arrays.asList(MediaType.APPLICATION_PROBLEM_JSON, MediaType.APPLICATION_PROBLEM_XML);
    private final ContentNegotiationManager contentNegotiationManager;
    private final HashSet<String> safeExtensions = new HashSet();
    @Nullable
    private final ArrayList<ErrorResponse.Interceptor> errorResponseInterceptors;

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters) {
        this(converters, null, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager contentNegotiationManager) {
        this(converters, contentNegotiationManager, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice) {
        this(converters, manager, requestResponseBodyAdvice, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice, @Nullable List<ErrorResponse.Interceptor> interceptors) {
        super(converters, requestResponseBodyAdvice);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
        this.safeExtensions.addAll(this.contentNegotiationManager.getAllFileExtensions());
        this.safeExtensions.addAll(SAFE_EXTENSIONS);
        this.errorResponseInterceptors = CollectionUtils.isNotEmpty(interceptors) ? new ArrayList<ErrorResponse.Interceptor>(interceptors) : null;
    }

    protected <T> void writeWithMessageConverters(@Nullable T value, @Nullable MethodParameter returnType, RequestContext context) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        MediaType mediaType;
        Object targetType;
        Class valueType;
        Object body;
        if (value instanceof CharSequence) {
            body = value.toString();
            valueType = String.class;
            targetType = String.class;
        } else {
            body = value;
            valueType = this.getReturnValueType(body, returnType);
            targetType = returnType == null ? ResolvableType.forInstance(body).getType() : GenericTypeResolver.resolveType((Type)this.getGenericType(returnType), (Class)returnType.getContainingClass());
        }
        if (this.isResourceType(value, returnType)) {
            String headerRange;
            context.setHeader("Accept-Ranges", "bytes");
            if (value != null && (headerRange = context.requestHeaders().getFirst("Range")) != null && context.getStatus() == 200) {
                Resource resource = (Resource)value;
                try {
                    List<HttpRange> httpRanges = HttpRange.parseRanges(headerRange);
                    context.setStatus(HttpStatus.PARTIAL_CONTENT);
                    body = HttpRange.toResourceRegions(httpRanges, resource);
                    valueType = body.getClass();
                    targetType = RESOURCE_REGION_LIST_TYPE;
                }
                catch (IllegalArgumentException ex) {
                    context.setHeader("Content-Range", "bytes */" + resource.contentLength());
                    context.setStatus(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value());
                }
            }
        }
        MediaType selectedMediaType = null;
        boolean isContentTypePreset = false;
        String contentType = context.getResponseContentType();
        if (contentType != null && (isContentTypePreset = (mediaType = MediaType.parseMediaType(contentType)).isConcrete())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found 'Content-Type:{}' in response", (Object)contentType);
            }
            selectedMediaType = mediaType;
        }
        if (!isContentTypePreset) {
            List<MediaType> acceptableTypes;
            try {
                acceptableTypes = this.getAcceptableMediaTypes(context);
            }
            catch (HttpMediaTypeNotAcceptableException ex) {
                int series = context.getStatus() / 100;
                if (body == null || series == 4 || series == 5) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring error response content (if any). {}", (Object)ex.toString());
                    }
                    return;
                }
                throw ex;
            }
            List<MediaType> producibleTypes = this.getProducibleMediaTypes(context, valueType, (Type)targetType);
            if (body != null && producibleTypes.isEmpty()) {
                throw new HttpMessageNotWritableException("No converter found for return value of type: " + valueType);
            }
            ArrayList<MediaType> compatibleMediaTypes = new ArrayList<MediaType>();
            this.determineCompatibleMediaTypes(acceptableTypes, producibleTypes, compatibleMediaTypes);
            if (compatibleMediaTypes.isEmpty() && ProblemDetail.class.isAssignableFrom(valueType)) {
                this.determineCompatibleMediaTypes(problemMediaTypes, producibleTypes, compatibleMediaTypes);
            }
            if (compatibleMediaTypes.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No match for {}, supported: {}", acceptableTypes, (Object)producibleTypes);
                }
                if (body != null) {
                    throw new HttpMediaTypeNotAcceptableException(producibleTypes);
                }
                return;
            }
            MimeTypeUtils.sortBySpecificity(compatibleMediaTypes);
            for (MediaType mediaType2 : compatibleMediaTypes) {
                if (mediaType2.isConcrete()) {
                    selectedMediaType = mediaType2;
                    break;
                }
                if (!mediaType2.isPresentIn(ALL_APPLICATION_MEDIA_TYPES)) continue;
                selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
                break;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using '{}', given {} and supported {}", new Object[]{selectedMediaType, acceptableTypes, producibleTypes});
            }
        }
        if (selectedMediaType != null) {
            RequestResponseBodyAdviceChain advice = this.getAdvice();
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter converter : this.messageConverters) {
                GenericHttpMessageConverter generic;
                GenericHttpMessageConverter genericHttpMessageConverter = generic = converter instanceof GenericHttpMessageConverter ? (GenericHttpMessageConverter)converter : null;
                if (!(generic != null ? generic.canWrite((Type)targetType, valueType, selectedMediaType) : converter.canWrite(valueType, selectedMediaType))) continue;
                if ((body = advice.beforeBodyWrite(body, returnType, selectedMediaType, converter, context)) != null) {
                    if (this.logger.isDebugEnabled()) {
                        Object theBody = body;
                        LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> "Writing [%s]".formatted(LogFormatUtils.formatValue((Object)theBody, (traceOn == false ? 1 : 0) != 0)));
                    }
                    this.addContentDispositionHeader(context);
                    if (generic != null) {
                        generic.write(body, (Type)targetType, selectedMediaType, context.asHttpOutputMessage());
                    } else {
                        converter.write(body, selectedMediaType, context.asHttpOutputMessage());
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Nothing to write: null body");
                }
                return;
            }
        }
        if (body != null) {
            HandlerMatchingMetadata matchingMetadata = context.getMatchingMetadata();
            if (matchingMetadata != null) {
                Object[] producibleMediaTypes = matchingMetadata.getProducibleMediaTypes();
                if (isContentTypePreset || ObjectUtils.isNotEmpty((Object[])producibleMediaTypes)) {
                    throw new HttpMessageNotWritableException("No converter for [%s] with preset Content-Type '%s'".formatted(valueType, contentType));
                }
            }
            throw new HttpMediaTypeNotAcceptableException(this.getSupportedMediaTypes(body.getClass()));
        }
    }

    protected Class<?> getReturnValueType(@Nullable Object value, @Nullable MethodParameter returnType) {
        if (value != null) {
            return value.getClass();
        }
        if (returnType != null) {
            return returnType.getParameterType();
        }
        throw new IllegalStateException("return-value and return-type must not be null at same time");
    }

    protected boolean isResourceType(@Nullable Object value, @Nullable MethodParameter returnType) {
        Class<?> clazz = this.getReturnValueType(value, returnType);
        return clazz != InputStreamResource.class && Resource.class.isAssignableFrom(clazz);
    }

    private Type getGenericType(MethodParameter returnType) {
        if (HttpEntity.class.isAssignableFrom(returnType.getParameterType())) {
            return ResolvableType.forType((Type)returnType.getGenericParameterType()).getGeneric(new int[0]).getType();
        }
        return returnType.getGenericParameterType();
    }

    protected List<MediaType> getProducibleMediaTypes(RequestContext request, Class<?> valueClass) {
        return this.getProducibleMediaTypes(request, valueClass, null);
    }

    protected List<MediaType> getProducibleMediaTypes(RequestContext request, Class<?> valueClass, @Nullable Type targetType) {
        Object[] mediaTypes;
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null && ObjectUtils.isNotEmpty((Object[])(mediaTypes = matchingMetadata.getProducibleMediaTypes()))) {
            return Arrays.asList(mediaTypes);
        }
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (HttpMessageConverter converter : this.messageConverters) {
            if (converter instanceof GenericHttpMessageConverter) {
                GenericHttpMessageConverter generic = (GenericHttpMessageConverter)converter;
                if (targetType != null) {
                    if (!generic.canWrite(targetType, valueClass, null)) continue;
                    result.addAll(converter.getSupportedMediaTypes(valueClass));
                    continue;
                }
            }
            if (!converter.canWrite(valueClass, null)) continue;
            result.addAll(converter.getSupportedMediaTypes(valueClass));
        }
        return result.isEmpty() ? Collections.singletonList(MediaType.ALL) : new ArrayList(result);
    }

    protected void invokeErrorResponseInterceptors(ProblemDetail detail, @Nullable ErrorResponse errorResponse) {
        if (this.errorResponseInterceptors != null) {
            try {
                for (ErrorResponse.Interceptor handler : this.errorResponseInterceptors) {
                    handler.handleError(detail, errorResponse);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private List<MediaType> getAcceptableMediaTypes(RequestContext request) throws HttpMediaTypeNotAcceptableException {
        return this.contentNegotiationManager.resolveMediaTypes(request);
    }

    private void determineCompatibleMediaTypes(List<MediaType> acceptableTypes, List<MediaType> producibleTypes, List<MediaType> mediaTypesToUse) {
        for (MediaType requestedType : acceptableTypes) {
            for (MediaType producibleType : producibleTypes) {
                if (!requestedType.isCompatibleWith(producibleType)) continue;
                mediaTypesToUse.add(this.getMostSpecificMediaType(requestedType, producibleType));
            }
        }
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        MediaType produceTypeToUse = produceType.copyQualityValue(acceptType);
        if (acceptType.isLessSpecific(produceTypeToUse)) {
            return produceTypeToUse;
        }
        return acceptType;
    }

    private void addContentDispositionHeader(RequestContext request) {
        if (request.containsResponseHeader("Content-Disposition")) {
            return;
        }
        try {
            int status = request.getStatus();
            if (status < 200 || status > 299 && status < 400) {
                return;
            }
        }
        catch (Throwable status) {
            // empty catch block
        }
        String requestUri = request.getRequestURI();
        int index = requestUri.lastIndexOf(47) + 1;
        String filename = requestUri.substring(index);
        String pathParams = "";
        index = filename.indexOf(59);
        if (index != -1) {
            pathParams = filename.substring(index);
            filename = filename.substring(0, index);
        }
        filename = UriUtils.decode(filename, StandardCharsets.UTF_8);
        String ext = StringUtils.getFilenameExtension((String)filename);
        pathParams = UriUtils.decode(pathParams, StandardCharsets.UTF_8);
        String extInPathParams = StringUtils.getFilenameExtension((String)pathParams);
        if (this.notSafeExtension(request, ext) || this.notSafeExtension(request, extInPathParams)) {
            request.addHeader("Content-Disposition", "inline;filename=f.txt");
        }
    }

    private boolean notSafeExtension(RequestContext request, @Nullable String extension) {
        MediaType mediaType;
        if (StringUtils.isBlank((String)extension)) {
            return false;
        }
        if (this.safeExtensions.contains(extension = extension.toLowerCase(Locale.ROOT))) {
            return false;
        }
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null) {
            Object[] mediaTypes;
            PathPattern bestMatchingPattern = matchingMetadata.getBestMatchingPattern();
            if (bestMatchingPattern != null && bestMatchingPattern.getPatternString().endsWith("." + extension)) {
                return false;
            }
            if (extension.equals("html") && ObjectUtils.isNotEmpty((Object[])(mediaTypes = matchingMetadata.getProducibleMediaTypes())) && ObjectUtils.containsElement((Object[])mediaTypes, (Object)MediaType.TEXT_HTML)) {
                return false;
            }
        }
        return (mediaType = this.resolveMediaType(request, extension)) == null || !this.safeMediaType(mediaType);
    }

    @Nullable
    private MediaType resolveMediaType(RequestContext request, String extension) {
        return MediaType.fromFileName("file." + extension);
    }

    private boolean safeMediaType(MediaType mediaType) {
        return SAFE_MEDIA_BASE_TYPES.contains(mediaType.getType()) || mediaType.getSubtype().endsWith("+xml");
    }
}

