/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.Conventions;
import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpMethod;
import infra.http.HttpOutputMessage;
import infra.http.HttpRequest;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LogFormatUtils;
import infra.util.MimeTypeUtils;
import infra.validation.BindingResult;
import infra.validation.Errors;
import infra.validation.annotation.ValidationAnnotationUtils;
import infra.web.BindingContext;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.RequestContext;
import infra.web.bind.MethodArgumentNotValidException;
import infra.web.bind.WebDataBinder;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.bind.resolver.RequestResponseBodyAdviceChain;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractMessageConverterMethodArgumentResolver
implements ParameterResolvingStrategy {
    private static final EnumSet<HttpMethod> SUPPORTED_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private static final Object NO_VALUE = new Object();
    protected final List<HttpMessageConverter<?>> messageConverters;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RequestResponseBodyAdviceChain advice;

    public AbstractMessageConverterMethodArgumentResolver(List<HttpMessageConverter<?>> converters) {
        this(converters, null);
    }

    public AbstractMessageConverterMethodArgumentResolver(List<HttpMessageConverter<?>> converters, @Nullable List<Object> requestResponseBodyAdvice) {
        Assert.notEmpty(converters, (String)"'messageConverters' must not be empty");
        this.messageConverters = converters;
        this.advice = new RequestResponseBodyAdviceChain(requestResponseBodyAdvice);
    }

    RequestResponseBodyAdviceChain getAdvice() {
        return this.advice;
    }

    @Nullable
    protected Object readWithMessageConverters(RequestContext request, MethodParameter parameter, Type paramType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        return this.readWithMessageConverters((HttpInputMessage)request, parameter, paramType);
    }

    @Nullable
    protected <T> Object readWithMessageConverters(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        MediaType contentType;
        Class<Object> targetClass;
        Class contextClass = parameter.getContainingClass();
        Class<Object> clazz = targetClass = targetType instanceof Class ? (Class<Object>)((Object)targetType) : null;
        if (targetClass == null) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            targetClass = resolvableType.resolve();
        }
        boolean noContentType = false;
        try {
            contentType = inputMessage.getHeaders().getContentType();
        }
        catch (InvalidMediaTypeException ex) {
            throw new HttpMediaTypeNotSupportedException(ex.getMessage(), this.getSupportedMediaTypes(targetClass != null ? targetClass : Object.class));
        }
        if (contentType == null) {
            noContentType = true;
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        Object body = NO_VALUE;
        EmptyBodyCheckingHttpInputMessage message = null;
        try {
            message = new EmptyBodyCheckingHttpInputMessage(inputMessage);
            RequestResponseBodyAdviceChain adviceChain = this.getAdvice();
            for (HttpMessageConverter<Object> httpMessageConverter : this.messageConverters) {
                if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)httpMessageConverter;
                    if (!genericConverter.canRead(targetType, contextClass, contentType)) continue;
                    if (message.hasBody()) {
                        HttpInputMessage msgToUse = adviceChain.beforeBodyRead(message, parameter, targetType, httpMessageConverter);
                        body = genericConverter.read(targetType, contextClass, msgToUse);
                        body = adviceChain.afterBodyRead(body, msgToUse, parameter, targetType, httpMessageConverter);
                        break;
                    }
                    body = adviceChain.handleEmptyBody(null, message, parameter, targetType, httpMessageConverter);
                    break;
                }
                if (targetClass == null || !httpMessageConverter.canRead(targetClass, contentType)) continue;
                if (message.hasBody()) {
                    HttpInputMessage msgToUse = adviceChain.beforeBodyRead(message, parameter, targetType, httpMessageConverter);
                    body = httpMessageConverter.read(targetClass, msgToUse);
                    body = adviceChain.afterBodyRead(body, msgToUse, parameter, targetType, httpMessageConverter);
                    break;
                }
                body = adviceChain.handleEmptyBody(null, message, parameter, targetType, httpMessageConverter);
                break;
            }
            if (body == NO_VALUE && noContentType && !message.hasBody()) {
                body = adviceChain.handleEmptyBody(null, message, parameter, targetType, new NoContentTypeHttpMessageConverter());
            }
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", ex, inputMessage);
        }
        finally {
            if (message != null && message.hasBody()) {
                this.closeStreamIfNecessary(message.getBody());
            }
        }
        if (body == NO_VALUE) {
            HttpMethod httpMethod;
            if (inputMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)((Object)inputMessage);
                v1 = httpRequest.getMethod();
            } else {
                v1 = httpMethod = null;
            }
            if (!SUPPORTED_METHODS.contains((Object)httpMethod) || noContentType && !message.hasBody()) {
                return null;
            }
            throw new HttpMediaTypeNotSupportedException(contentType, this.getSupportedMediaTypes(targetClass != null ? targetClass : Object.class), httpMethod);
        }
        if (this.logger.isDebugEnabled()) {
            Object theBody = body;
            MediaType selectedContentType = contentType;
            LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> "Read \"%s\" to [%s]".formatted(selectedContentType, LogFormatUtils.formatValue((Object)theBody, (traceOn == false ? 1 : 0) != 0)));
        }
        return body;
    }

    protected void validateIfApplicable(RequestContext context, MethodParameter parameter, @Nullable Object arg) throws Throwable {
        BindingContext bindingContext = context.getBinding();
        if (bindingContext != null) {
            String name = Conventions.getVariableNameForParameter((MethodParameter)parameter);
            ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
            WebDataBinder binder = bindingContext.createBinder(context, arg, name, type);
            if (arg != null) {
                this.validateIfApplicable(binder, parameter);
                if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                    throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
                }
            }
            bindingContext.addAttribute(BindingResult.MODEL_KEY_PREFIX + name, binder.getBindingResult());
        }
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
            if (validationHints == null) continue;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    protected List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        LinkedHashSet<MediaType> mediaTypeSet = new LinkedHashSet<MediaType>();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            mediaTypeSet.addAll(converter.getSupportedMediaTypes(clazz));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(mediaTypeSet);
        MimeTypeUtils.sortBySpecificity(result);
        return result;
    }

    void closeStreamIfNecessary(InputStream body) {
    }

    private static class EmptyBodyCheckingHttpInputMessage
    implements HttpInputMessage {
        private final HttpHeaders headers;
        @Nullable
        private final InputStream body;

        public EmptyBodyCheckingHttpInputMessage(HttpInputMessage inputMessage) throws IOException {
            this.headers = inputMessage.getHeaders();
            InputStream inputStream = inputMessage.getBody();
            if (inputStream.markSupported()) {
                inputStream.mark(1);
                this.body = inputStream.read() != -1 ? inputStream : null;
                inputStream.reset();
            } else {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                int b = pushbackInputStream.read();
                if (b == -1) {
                    this.body = null;
                } else {
                    this.body = pushbackInputStream;
                    pushbackInputStream.unread(b);
                }
            }
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public InputStream getBody() {
            return this.body != null ? this.body : InputStream.nullInputStream();
        }

        public boolean hasBody() {
            return this.body != null;
        }
    }

    private static class NoContentTypeHttpMessageConverter
    implements HttpMessageConverter<String> {
        private NoContentTypeHttpMessageConverter() {
        }

        @Override
        public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public List<MediaType> getSupportedMediaTypes() {
            return Collections.emptyList();
        }

        @Override
        public String read(Class<? extends String> clazz, HttpInputMessage inputMessage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(String s, @Nullable MediaType contentType, HttpOutputMessage outputMessage) {
            throw new UnsupportedOperationException();
        }
    }
}

