/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.beans.ConfigurablePropertyAccessor;
import infra.beans.PropertyValue;
import infra.beans.PropertyValues;
import infra.core.MethodParameter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.validation.BindException;
import infra.validation.DataBinder;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.multipart.MultipartFile;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    @Nullable
    private String fieldMarkerPrefix = "_";
    @Nullable
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(@Nullable String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    @Nullable
    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(@Nullable String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    @Nullable
    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    @Nullable
    protected Object resolvePrefixValue(String name, Class<?> type, BiFunction<String, Class<?>, Object> resolver) {
        Object value = resolver.apply(name, type);
        if (value == null) {
            String prefix = this.getFieldDefaultPrefix();
            if (prefix != null) {
                value = resolver.apply(prefix + name, type);
            }
            if (value == null && (prefix = this.getFieldMarkerPrefix()) != null && resolver.apply(prefix + name, type) != null) {
                value = this.getEmptyValue(type);
            }
        }
        return value;
    }

    protected void doBind(PropertyValues values) {
        this.checkFieldDefaults(values);
        this.checkFieldMarkers(values);
        this.adaptEmptyArrayIndices(values);
        super.doBind(values);
    }

    protected void checkFieldDefaults(PropertyValues values) {
        String fieldDefaultPrefix = this.getFieldDefaultPrefix();
        if (fieldDefaultPrefix != null) {
            ConfigurablePropertyAccessor propertyAccessor = this.getPropertyAccessor();
            for (PropertyValue pv : values.toArray()) {
                if (!pv.getName().startsWith(fieldDefaultPrefix)) continue;
                String field = pv.getName().substring(fieldDefaultPrefix.length());
                if (propertyAccessor.isWritableProperty(field) && !values.contains(field)) {
                    values.add(field, pv.getValue());
                }
                values.remove(pv);
            }
        }
    }

    protected void checkFieldMarkers(PropertyValues values) {
        String fieldMarkerPrefix = this.getFieldMarkerPrefix();
        if (fieldMarkerPrefix != null) {
            ConfigurablePropertyAccessor propertyAccessor = this.getPropertyAccessor();
            for (PropertyValue pv : values.toArray()) {
                if (!pv.getName().startsWith(fieldMarkerPrefix)) continue;
                String field = pv.getName().substring(fieldMarkerPrefix.length());
                if (propertyAccessor.isWritableProperty(field) && !values.contains(field)) {
                    Class fieldType = propertyAccessor.getPropertyType(field);
                    values.add(field, this.getEmptyValue(field, fieldType));
                }
                values.remove(pv);
            }
        }
    }

    protected void adaptEmptyArrayIndices(PropertyValues values) {
        ConfigurablePropertyAccessor propertyAccessor = this.getPropertyAccessor();
        for (PropertyValue pv : values.toArray()) {
            String name = pv.getName();
            if (!name.endsWith("[]")) continue;
            String field = name.substring(0, name.length() - 2);
            if (propertyAccessor.isWritableProperty(field) && !values.contains(field)) {
                values.add(field, pv.getValue());
            }
            values.remove(pv);
        }
    }

    @Nullable
    protected Object getEmptyValue(String field, @Nullable Class<?> fieldType) {
        return fieldType != null ? this.getEmptyValue(fieldType) : null;
    }

    @Nullable
    public Object getEmptyValue(Class<?> fieldType) {
        try {
            if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                return Boolean.FALSE;
            }
            if (fieldType.isArray()) {
                return Array.newInstance(fieldType.getComponentType(), 0);
            }
            if (Collection.class.isAssignableFrom(fieldType)) {
                return CollectionUtils.createCollection(fieldType, (int)0);
            }
            if (Map.class.isAssignableFrom(fieldType)) {
                return CollectionUtils.createMap(fieldType, (int)0);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Failed to create default value - falling back to null: {}", (Object)ex.getMessage());
        }
        return null;
    }

    public void construct(RequestContext request) {
        this.construct(new RequestValueResolver(request, this));
    }

    protected boolean shouldConstructArgument(MethodParameter param) {
        Class type = param.nestedIfOptional().getNestedParameterType();
        return super.shouldConstructArgument(param) && !MultipartFile.class.isAssignableFrom(type);
    }

    public void bind(RequestContext request) {
        if (this.shouldNotBindPropertyValues()) {
            return;
        }
        this.doBind(this.getValuesToBind(request));
    }

    public PropertyValues getValuesToBind(RequestContext request) {
        HandlerMatchingMetadata matchingMetadata;
        MultiValueMap<String, MultipartFile> multipartFiles;
        PropertyValues propertyValues = new PropertyValues(request.getParameters().toArrayMap(String[]::new));
        if (request.isMultipart() && !(multipartFiles = request.getMultipartRequest().getMultipartFiles()).isEmpty()) {
            this.bindMultipart((Map<String, List<MultipartFile>>)multipartFiles, propertyValues);
        }
        if ((matchingMetadata = request.getMatchingMetadata()) != null) {
            Map<String, String> uriVariables = matchingMetadata.getUriVariables();
            propertyValues.add(uriVariables);
        }
        return propertyValues;
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, PropertyValues mpvs) {
        for (Map.Entry<String, List<MultipartFile>> entry : multipartFiles.entrySet()) {
            List<MultipartFile> values = entry.getValue();
            String key = entry.getKey();
            if (values.size() == 1) {
                MultipartFile value = values.get(0);
                if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
                mpvs.add(key, (Object)value);
                continue;
            }
            mpvs.add(key, values);
        }
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }

    protected static class RequestValueResolver
    implements DataBinder.ValueResolver {
        private final RequestContext request;
        private final WebDataBinder dataBinder;
        @Nullable
        private Set<String> parameterNames;

        protected RequestValueResolver(RequestContext request, WebDataBinder dataBinder) {
            this.request = request;
            this.dataBinder = dataBinder;
        }

        protected RequestContext getRequest() {
            return this.request;
        }

        @Nullable
        public final Object resolveValue(String name, Class<?> paramType) {
            Object value = this.getRequestParameter(name, paramType);
            if (value == null) {
                value = this.dataBinder.resolvePrefixValue(name, paramType, this::getRequestParameter);
            }
            if (value == null) {
                value = this.getMultipartValue(name, paramType);
            }
            return value;
        }

        @Nullable
        protected Object getRequestParameter(String name, Class<?> type) {
            String[] value = this.request.getParameters(name);
            if (value == null) {
                HandlerMatchingMetadata matchingMetadata = this.request.getMatchingMetadata();
                if (matchingMetadata != null) {
                    return matchingMetadata.getUriVariables().get(name);
                }
            } else if (value.length == 1) {
                return value[0];
            }
            return value;
        }

        @Nullable
        private Object getMultipartValue(String name, Class<?> paramType) {
            List<MultipartFile> files;
            if (this.request.isMultipart() && CollectionUtils.isNotEmpty(files = this.request.getMultipartRequest().getFiles(name))) {
                return files.size() == 1 ? files.get(0) : files;
            }
            return null;
        }

        public Set<String> getNames() {
            if (this.parameterNames == null) {
                this.parameterNames = this.initParameterNames(this.request);
            }
            return this.parameterNames;
        }

        protected Set<String> initParameterNames(RequestContext request) {
            return new LinkedHashSet<String>(request.getParameters().keySet());
        }
    }
}

