/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.lang.Assert;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.bind.RequestBindingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UnsatisfiedRequestParameterException
extends RequestBindingException {
    private final List<String[]> paramConditions;
    private final MultiValueMap<String, String> actualParams;

    public UnsatisfiedRequestParameterException(String[] paramConditions, MultiValueMap<String, String> actualParams) {
        this(List.of(paramConditions), actualParams);
    }

    public UnsatisfiedRequestParameterException(List<String[]> paramConditions, MultiValueMap<String, String> actualParams) {
        super("", null, new Object[]{UnsatisfiedRequestParameterException.paramsToStringList(paramConditions)});
        Assert.notEmpty(paramConditions, (String)"Parameter conditions must not be empty");
        this.actualParams = actualParams;
        this.paramConditions = paramConditions;
        this.getBody().setDetail("Invalid request parameters.");
    }

    private static List<String> paramsToStringList(List<String[]> paramConditions) {
        Assert.notEmpty(paramConditions, (String)"Parameter conditions must not be empty");
        return paramConditions.stream().map(condition -> "\"" + StringUtils.arrayToDelimitedString((Object[])condition, (String)", ") + "\"").collect(Collectors.toList());
    }

    public String getMessage() {
        return "Parameter conditions %s not met for actual request parameters: %s".formatted(String.join((CharSequence)" OR ", UnsatisfiedRequestParameterException.paramsToStringList(this.paramConditions)), UnsatisfiedRequestParameterException.requestParameterMapToString(this.actualParams));
    }

    public final String[] getParamConditions() {
        return this.paramConditions.get(0);
    }

    public final List<String[]> getParamConditionGroups() {
        return this.paramConditions;
    }

    public final MultiValueMap<String, String> getActualParams() {
        return this.actualParams;
    }

    private static String requestParameterMapToString(MultiValueMap<String, String> actualParams) {
        StringBuilder result = new StringBuilder();
        Iterator it = actualParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            result.append((String)entry.getKey()).append('=').append(ObjectUtils.nullSafeToString(entry.getValue()));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

