/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.core.NestedRuntimeException;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.lang.Nullable;
import infra.web.ErrorResponse;

public class RequestBindingException
extends NestedRuntimeException
implements ErrorResponse {
    private final ProblemDetail body = ProblemDetail.forStatus(this.getStatusCode());
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    public RequestBindingException(@Nullable String msg) {
        this(msg, null, null);
    }

    public RequestBindingException(@Nullable String msg, @Nullable Throwable cause) {
        this(msg, cause, null, null);
    }

    protected RequestBindingException(@Nullable String msg, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        this(msg, null, messageDetailCode, messageDetailArguments);
    }

    protected RequestBindingException(@Nullable String msg, @Nullable Throwable cause, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(msg, cause);
        if (messageDetailCode == null) {
            messageDetailCode = ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
        }
        this.messageDetailCode = messageDetailCode;
        this.messageDetailArguments = messageDetailArguments;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    @Nullable
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }
}

