/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.core.MethodParameter;
import infra.lang.Nullable;
import infra.web.bind.MissingRequestValueException;

public class MissingRequestParameterException
extends MissingRequestValueException {
    private final String parameterName;
    private final String parameterType;
    @Nullable
    private final MethodParameter parameter;

    public MissingRequestParameterException(String parameterName, String parameterType) {
        super("", false, null, new Object[]{parameterName});
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.parameter = null;
        this.getBody().setDetail(MissingRequestParameterException.initBodyDetail(this.parameterName));
    }

    public MissingRequestParameterException(String parameterName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{parameterName});
        this.parameterName = parameterName;
        this.parameterType = parameter.getNestedParameterType().getSimpleName();
        this.parameter = parameter;
        this.getBody().setDetail(MissingRequestParameterException.initBodyDetail(this.parameterName));
    }

    private static String initBodyDetail(String name) {
        return "Required parameter '" + name + "' is not present.";
    }

    public String getMessage() {
        return "Required request parameter '%s' for method parameter type %s is %s".formatted(this.parameterName, this.parameterType, this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getParameterName() {
        return this.parameterName;
    }

    public final String getParameterType() {
        return this.parameterType;
    }

    @Nullable
    public MethodParameter getMethodParameter() {
        return this.parameter;
    }
}

