/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.core.MethodParameter;
import infra.http.HttpStatus;
import infra.web.bind.MissingRequestValueException;

public class MissingPathVariableException
extends MissingRequestValueException {
    private final String variableName;
    private final MethodParameter parameter;

    public MissingPathVariableException(String variableName, MethodParameter parameter) {
        this(variableName, parameter, false);
    }

    public MissingPathVariableException(String variableName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{variableName});
        this.variableName = variableName;
        this.parameter = parameter;
        this.getBody().setDetail("Required path variable '%s' is not present.".formatted(variableName));
    }

    public String getMessage() {
        return "Required URI template variable '%s' for method parameter type %s is %s".formatted(this.variableName, this.parameter.getNestedParameterType().getSimpleName(), this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getVariableName() {
        return this.variableName;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }

    @Override
    public HttpStatus getStatusCode() {
        return this.isMissingAfterConversion() ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

