/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.core.MethodParameter;
import infra.web.bind.MissingRequestValueException;

public class MissingMatrixVariableException
extends MissingRequestValueException {
    private final String variableName;
    private final MethodParameter parameter;

    public MissingMatrixVariableException(String variableName, MethodParameter parameter) {
        this(variableName, parameter, false);
    }

    public MissingMatrixVariableException(String variableName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{variableName});
        this.variableName = variableName;
        this.parameter = parameter;
        this.getBody().setDetail("Required path parameter '%s' is not present.".formatted(this.variableName));
    }

    public String getMessage() {
        return "Required matrix variable '%s' for method parameter type %s is %s".formatted(this.variableName, this.parameter.getNestedParameterType().getSimpleName(), this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getVariableName() {
        return this.variableName;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }
}

