/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind;

import infra.context.MessageSource;
import infra.core.MethodParameter;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.validation.BindException;
import infra.validation.BindingResult;
import infra.validation.ObjectError;
import infra.web.ErrorResponse;
import infra.web.util.BindErrorUtils;
import java.util.Locale;

public class MethodArgumentNotValidException
extends BindException
implements ErrorResponse {
    private final MethodParameter parameter;
    private final ProblemDetail body;

    public MethodArgumentNotValidException(MethodParameter parameter, BindingResult bindingResult) {
        super(bindingResult);
        this.parameter = parameter;
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), "Invalid request content.");
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public Object[] getDetailMessageArguments(MessageSource source, Locale locale) {
        return new Object[]{BindErrorUtils.resolveAndJoin(this.getGlobalErrors(), source, locale), BindErrorUtils.resolveAndJoin(this.getFieldErrors(), source, locale)};
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{BindErrorUtils.resolveAndJoin(this.getGlobalErrors()), BindErrorUtils.resolveAndJoin(this.getFieldErrors())};
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed for argument [").append(this.parameter.getParameterIndex()).append("] in ").append(this.parameter.getExecutable().toGenericString());
        BindingResult bindingResult = this.getBindingResult();
        if (bindingResult.getErrorCount() > 1) {
            sb.append(" with ").append(bindingResult.getErrorCount()).append(" errors");
        }
        sb.append(": ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append('[').append(error).append("] ");
        }
        return sb.toString();
    }
}

