/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryAware;
import infra.core.task.AsyncTaskExecutor;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.async.CallableProcessingInterceptor;
import java.util.concurrent.Callable;

public class WebAsyncTask<V>
implements BeanFactoryAware {
    private final Callable<V> callable;
    @Nullable
    private Long timeout;
    @Nullable
    private AsyncTaskExecutor executor;
    @Nullable
    private String executorName;
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private Callable<V> timeoutCallback;
    @Nullable
    private Callable<V> errorCallback;
    @Nullable
    private Runnable completionCallback;

    public WebAsyncTask(Callable<V> callable) {
        Assert.notNull(callable, (String)"Callable is required");
        this.callable = callable;
    }

    public WebAsyncTask(@Nullable Long timeout, Callable<V> callable) {
        this(callable);
        this.timeout = timeout;
    }

    public WebAsyncTask(@Nullable Long timeout, String executorName, Callable<V> callable) {
        this(callable);
        Assert.notNull((Object)executorName, (String)"Executor name is required");
        this.executorName = executorName;
        this.timeout = timeout;
    }

    public WebAsyncTask(@Nullable Long timeout, AsyncTaskExecutor executor, Callable<V> callable) {
        this(callable);
        Assert.notNull((Object)executor, (String)"Executor is required");
        this.executor = executor;
        this.timeout = timeout;
    }

    public Callable<?> getCallable() {
        return this.callable;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Nullable
    public AsyncTaskExecutor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.executorName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory is required to look up an executor bean by name");
            return (AsyncTaskExecutor)this.beanFactory.getBean(this.executorName, AsyncTaskExecutor.class);
        }
        return null;
    }

    public void onTimeout(Callable<V> callback) {
        this.timeoutCallback = callback;
    }

    public void onError(Callable<V> callback) {
        this.errorCallback = callback;
    }

    public void onCompletion(Runnable callback) {
        this.completionCallback = callback;
    }

    CallableProcessingInterceptor createInterceptor() {
        return new CallableProcessingInterceptor(){

            @Override
            public <T> Object handleTimeout(RequestContext request, Callable<T> task) throws Exception {
                return WebAsyncTask.this.timeoutCallback != null ? WebAsyncTask.this.timeoutCallback.call() : RESULT_NONE;
            }

            @Override
            public <T> Object handleError(RequestContext request, Callable<T> task, Throwable t) throws Exception {
                return WebAsyncTask.this.errorCallback != null ? WebAsyncTask.this.errorCallback.call() : RESULT_NONE;
            }

            @Override
            public <T> void afterCompletion(RequestContext request, Callable<T> task) throws Exception {
                if (WebAsyncTask.this.completionCallback != null) {
                    WebAsyncTask.this.completionCallback.run();
                }
            }
        };
    }
}

