/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.context.ApplicationContext;
import infra.core.task.AsyncTaskExecutor;
import infra.core.task.SimpleAsyncTaskExecutor;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;
import infra.web.async.CallableProcessingInterceptor;
import infra.web.async.DeferredResultProcessingInterceptor;
import infra.web.async.WebAsyncManager;
import java.util.List;

public class WebAsyncManagerFactory {
    @Nullable
    private List<CallableProcessingInterceptor> callableInterceptors;
    @Nullable
    private List<DeferredResultProcessingInterceptor> deferredResultInterceptors;
    @Nullable
    private Long asyncRequestTimeout;
    private AsyncTaskExecutor taskExecutor = new MvcSimpleAsyncTaskExecutor();

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setAsyncRequestTimeout(@Nullable Long timeout) {
        this.asyncRequestTimeout = timeout;
    }

    public void setCallableInterceptors(@Nullable List<CallableProcessingInterceptor> interceptors) {
        this.callableInterceptors = interceptors;
    }

    public void setDeferredResultInterceptors(@Nullable List<DeferredResultProcessingInterceptor> interceptors) {
        this.deferredResultInterceptors = interceptors;
    }

    public WebAsyncManager getWebAsyncManager(RequestContext request) {
        WebAsyncManager asyncManager = new WebAsyncManager(request);
        asyncManager.setTaskExecutor(this.taskExecutor);
        asyncManager.setTimeout(this.asyncRequestTimeout);
        asyncManager.registerCallableInterceptors(this.callableInterceptors);
        asyncManager.registerDeferredResultInterceptors(this.deferredResultInterceptors);
        return asyncManager;
    }

    public static WebAsyncManagerFactory find(ApplicationContext context) {
        WebAsyncManagerFactory factory = (WebAsyncManagerFactory)BeanFactoryUtils.find((BeanFactory)context, WebAsyncManagerFactory.class);
        if (factory != null) {
            return factory;
        }
        return new WebAsyncManagerFactory();
    }

    private static class MvcSimpleAsyncTaskExecutor
    extends SimpleAsyncTaskExecutor {
        private static boolean taskExecutorWarning = true;

        public MvcSimpleAsyncTaskExecutor() {
            super("MvcAsync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable task) {
            Logger logger;
            if (taskExecutorWarning && (logger = LoggerFactory.getLogger(WebAsyncManagerFactory.class)).isWarnEnabled()) {
                MvcSimpleAsyncTaskExecutor mvcSimpleAsyncTaskExecutor = this;
                synchronized (mvcSimpleAsyncTaskExecutor) {
                    if (taskExecutorWarning) {
                        logger.warn("!!!\nPerforming asynchronous handling through the default Web MVC SimpleAsyncTaskExecutor.\nThis executor is not suitable for production use under load.\nPlease, configure an AsyncTaskExecutor through the WebMvc config.\n-------------------------------\n!!!");
                        taskExecutorWarning = false;
                    }
                }
            }
            super.execute(task);
        }
    }
}

