/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.core.task.AsyncTaskExecutor;
import infra.core.task.SimpleAsyncTaskExecutor;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.concurrent.Future;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.RequestContextHolder;
import infra.web.async.AsyncWebRequest;
import infra.web.async.CallableInterceptorChain;
import infra.web.async.CallableProcessingInterceptor;
import infra.web.async.DeferredResult;
import infra.web.async.DeferredResultInterceptorChain;
import infra.web.async.DeferredResultProcessingInterceptor;
import infra.web.async.TimeoutAsyncProcessingInterceptor;
import infra.web.async.WebAsyncTask;
import infra.web.util.DisconnectedClientHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;

public final class WebAsyncManager {
    public static final String WEB_ASYNC_REQUEST_ATTRIBUTE = WebAsyncManager.class.getName() + ".WEB_REQUEST";
    public static final String WEB_ASYNC_RESULT_ATTRIBUTE = WebAsyncManager.class.getName() + ".WEB_ASYNC_RESULT";
    private static final Object RESULT_NONE = new Object();
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "infra.web.server.DisconnectedClient";
    private static final DisconnectedClientHelper disconnectedClientHelper = new DisconnectedClientHelper("infra.web.server.DisconnectedClient");
    private static final AsyncTaskExecutor DEFAULT_TASK_EXECUTOR = new SimpleAsyncTaskExecutor(WebAsyncManager.class.getSimpleName());
    private static final Logger logger = LoggerFactory.getLogger(WebAsyncManager.class);
    private static final TimeoutAsyncProcessingInterceptor timeoutInterceptor = new TimeoutAsyncProcessingInterceptor();
    @Nullable
    private Long asyncRequestTimeout;
    private AsyncTaskExecutor taskExecutor = DEFAULT_TASK_EXECUTOR;
    @Nullable
    private volatile Object concurrentResult = RESULT_NONE;
    @Nullable
    private volatile Object[] concurrentResultContext;
    private volatile boolean errorHandlingInProgress;
    @Nullable
    private LinkedHashMap<Object, CallableProcessingInterceptor> callableInterceptors;
    @Nullable
    private LinkedHashMap<Object, DeferredResultProcessingInterceptor> deferredResultInterceptors;
    private final RequestContext requestContext;

    public WebAsyncManager(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTimeout(@Nullable Long timeout) {
        this.asyncRequestTimeout = timeout;
    }

    public boolean hasConcurrentResult() {
        return this.concurrentResult != RESULT_NONE;
    }

    @Nullable
    public Object getConcurrentResult() {
        return this.concurrentResult;
    }

    @Nullable
    public Object[] getConcurrentResultContext() {
        return this.concurrentResultContext;
    }

    @Nullable
    public CallableProcessingInterceptor getCallableInterceptor(Object key) {
        return this.callableInterceptors == null ? null : this.callableInterceptors.get(key);
    }

    @Nullable
    public DeferredResultProcessingInterceptor getDeferredResultInterceptor(Object key) {
        return this.deferredResultInterceptors == null ? null : this.deferredResultInterceptors.get(key);
    }

    public void registerCallableInterceptor(Object key, CallableProcessingInterceptor interceptor) {
        Assert.notNull((Object)key, (String)"Key is required");
        Assert.notNull((Object)interceptor, (String)"CallableProcessingInterceptor is required");
        if (this.callableInterceptors == null) {
            this.callableInterceptors = new LinkedHashMap();
        }
        this.callableInterceptors.put(key, interceptor);
    }

    public void registerCallableInterceptors(@Nullable List<CallableProcessingInterceptor> interceptors) {
        if (interceptors != null) {
            if (this.callableInterceptors == null) {
                this.callableInterceptors = new LinkedHashMap();
            }
            for (CallableProcessingInterceptor interceptor : interceptors) {
                String key = interceptor.getClass().getName() + ":" + interceptor.hashCode();
                this.callableInterceptors.put(key, interceptor);
            }
        }
    }

    public void registerDeferredResultInterceptor(Object key, DeferredResultProcessingInterceptor interceptor) {
        Assert.notNull((Object)key, (String)"Key is required");
        Assert.notNull((Object)interceptor, (String)"DeferredResultProcessingInterceptor is required");
        if (this.deferredResultInterceptors == null) {
            this.deferredResultInterceptors = new LinkedHashMap();
        }
        this.deferredResultInterceptors.put(key, interceptor);
    }

    public void registerDeferredResultInterceptors(@Nullable List<DeferredResultProcessingInterceptor> interceptors) {
        if (interceptors != null) {
            if (this.deferredResultInterceptors == null) {
                this.deferredResultInterceptors = new LinkedHashMap();
            }
            for (DeferredResultProcessingInterceptor interceptor : interceptors) {
                String key = interceptor.getClass().getName() + ":" + interceptor.hashCode();
                this.deferredResultInterceptors.put(key, interceptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConcurrentResult() {
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            this.concurrentResult = RESULT_NONE;
            this.concurrentResultContext = null;
        }
    }

    public void startCallableProcessing(Callable<?> callable, Object ... processingContext) throws Exception {
        Assert.notNull(callable, (String)"Callable is required");
        this.startCallableProcessing(new WebAsyncTask(callable), processingContext);
    }

    public void startCallableProcessing(WebAsyncTask<?> webAsyncTask, Object ... processingContext) throws Exception {
        AsyncTaskExecutor executor;
        Assert.notNull(webAsyncTask, (String)"WebAsyncTask is required");
        AsyncWebRequest asyncRequest = this.getAsyncWebRequest();
        Long timeout = webAsyncTask.getTimeout();
        if (timeout == null) {
            timeout = this.asyncRequestTimeout;
        }
        if (timeout != null) {
            asyncRequest.setTimeout(timeout);
        }
        if ((executor = webAsyncTask.getExecutor()) != null) {
            this.taskExecutor = executor;
        }
        ArrayList<CallableProcessingInterceptor> interceptors = new ArrayList<CallableProcessingInterceptor>(2);
        interceptors.add(webAsyncTask.createInterceptor());
        if (this.callableInterceptors != null) {
            interceptors.addAll(this.callableInterceptors.values());
        }
        interceptors.add(timeoutInterceptor);
        Callable<?> callable = webAsyncTask.getCallable();
        CallableInterceptorChain interceptorChain = new CallableInterceptorChain(interceptors);
        asyncRequest.addTimeoutHandler(() -> {
            Object result;
            if (logger.isDebugEnabled()) {
                logger.debug("Async request timeout for {}", (Object)this.formatRequestUri());
            }
            if ((result = interceptorChain.triggerAfterTimeout(this.requestContext, callable)) != CallableProcessingInterceptor.RESULT_NONE) {
                this.setConcurrentResultAndDispatch(result);
            }
        });
        asyncRequest.addErrorHandler(ex -> {
            if (!this.errorHandlingInProgress) {
                Object result;
                if (logger.isDebugEnabled()) {
                    logger.debug("Async request error for {}: {}", (Object)this.formatRequestUri(), ex);
                }
                result = (result = interceptorChain.triggerAfterError(this.requestContext, callable, (Throwable)ex)) != CallableProcessingInterceptor.RESULT_NONE ? result : ex;
                this.setConcurrentResultAndDispatch(result);
            }
        });
        asyncRequest.addCompletionHandler(() -> interceptorChain.triggerAfterCompletion(this.requestContext, callable));
        interceptorChain.applyBeforeConcurrentHandling(this.requestContext, callable);
        this.startAsyncProcessing(asyncRequest, processingContext);
        try {
            Future future = this.taskExecutor.submit(() -> {
                RequestContextHolder.set(this.requestContext);
                Object result = null;
                try {
                    interceptorChain.applyPreProcess(this.requestContext, callable);
                    result = callable.call();
                }
                catch (Throwable ex) {
                    result = ex;
                }
                finally {
                    result = interceptorChain.applyPostProcess(this.requestContext, callable, result);
                }
                this.setConcurrentResultAndDispatch(result);
                RequestContextHolder.cleanup();
            });
            interceptorChain.setTaskFuture((java.util.concurrent.Future<?>)future);
        }
        catch (Throwable ex2) {
            Object result = interceptorChain.applyPostProcess(this.requestContext, callable, ex2);
            this.setConcurrentResultAndDispatch(result);
        }
    }

    private AsyncWebRequest getAsyncWebRequest() {
        return this.requestContext.getAsyncWebRequest();
    }

    private String formatRequestUri() {
        return this.requestContext.getRequestURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConcurrentResultAndDispatch(@Nullable Object result) {
        Exception ex;
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            if (this.concurrentResult != RESULT_NONE) {
                return;
            }
            this.concurrentResult = result;
            this.errorHandlingInProgress = result instanceof Throwable;
        }
        AsyncWebRequest asyncRequest = this.getAsyncWebRequest();
        if (asyncRequest.isAsyncComplete()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Async result set but request already complete: {}", (Object)this.formatRequestUri());
            }
            return;
        }
        if (result instanceof Exception && disconnectedClientHelper.checkAndLogClientDisconnectedException(ex = (Exception)result)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Async %s, dispatch to %s".formatted(this.errorHandlingInProgress ? "error" : "result set", this.formatRequestUri()));
        }
        asyncRequest.dispatch(result);
    }

    public void startDeferredResultProcessing(DeferredResult<?> deferred, Object ... processingContext) throws Exception {
        Assert.notNull(deferred, (String)"DeferredResult is required");
        AsyncWebRequest asyncRequest = this.getAsyncWebRequest();
        Long timeout = deferred.getTimeoutValue();
        if (timeout == null) {
            timeout = this.asyncRequestTimeout;
        }
        if (timeout != null) {
            asyncRequest.setTimeout(timeout);
        }
        ArrayList<DeferredResultProcessingInterceptor> interceptors = new ArrayList<DeferredResultProcessingInterceptor>(2);
        interceptors.add(deferred.createInterceptor());
        if (this.deferredResultInterceptors != null) {
            interceptors.addAll(this.deferredResultInterceptors.values());
        }
        interceptors.add(timeoutInterceptor);
        DeferredResultInterceptorChain chain = new DeferredResultInterceptorChain(interceptors);
        asyncRequest.addTimeoutHandler(() -> {
            try {
                chain.triggerAfterTimeout(this.requestContext, deferred);
            }
            catch (Throwable ex) {
                this.setConcurrentResultAndDispatch(ex);
            }
        });
        asyncRequest.addErrorHandler(ex -> {
            if (!this.errorHandlingInProgress) {
                try {
                    if (!chain.triggerAfterError(this.requestContext, deferred, (Throwable)ex)) {
                        return;
                    }
                    deferred.setErrorResult(ex);
                }
                catch (Throwable interceptorEx) {
                    this.setConcurrentResultAndDispatch(interceptorEx);
                }
            }
        });
        asyncRequest.addCompletionHandler(() -> chain.triggerAfterCompletion(this.requestContext, deferred));
        chain.applyBeforeConcurrentHandling(this.requestContext, deferred);
        this.startAsyncProcessing(asyncRequest, processingContext);
        try {
            chain.applyPreProcess(this.requestContext, deferred);
            deferred.setResultHandler(result -> {
                result = chain.applyPostProcess(this.requestContext, deferred, result);
                this.setConcurrentResultAndDispatch(result);
            });
        }
        catch (Throwable ex2) {
            this.setConcurrentResultAndDispatch(ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsyncProcessing(AsyncWebRequest asyncRequest, Object[] processingContext) {
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            this.concurrentResult = RESULT_NONE;
            this.concurrentResultContext = processingContext;
            this.errorHandlingInProgress = false;
        }
        asyncRequest.startAsync();
        if (logger.isDebugEnabled()) {
            logger.debug("Started async request");
        }
    }

    @Nullable
    public static Object findHttpRequestHandler(RequestContext request) {
        WebAsyncManager asyncManager = request.getAsyncManager();
        Object[] concurrentResultContext = asyncManager.getConcurrentResultContext();
        if (concurrentResultContext != null && concurrentResultContext.length == 1) {
            return concurrentResultContext[0];
        }
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null) {
            return matchingMetadata.getHandler();
        }
        return null;
    }
}

