/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.lang.Nullable;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.async.DeferredResultProcessingInterceptor;
import java.util.ArrayList;

final class DeferredResultInterceptorChain {
    private final ArrayList<DeferredResultProcessingInterceptor> interceptors;
    private int preProcessingIndex = -1;

    public DeferredResultInterceptorChain(ArrayList<DeferredResultProcessingInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void applyBeforeConcurrentHandling(RequestContext request, DeferredResult<?> deferredResult) throws Exception {
        for (DeferredResultProcessingInterceptor interceptor : this.interceptors) {
            interceptor.beforeConcurrentHandling(request, deferredResult);
        }
    }

    public void applyPreProcess(RequestContext request, DeferredResult<?> deferredResult) throws Exception {
        for (DeferredResultProcessingInterceptor interceptor : this.interceptors) {
            interceptor.preProcess(request, deferredResult);
            ++this.preProcessingIndex;
        }
    }

    @Nullable
    public Object applyPostProcess(RequestContext request, DeferredResult<?> deferredResult, @Nullable Object concurrentResult) {
        try {
            for (int i = this.preProcessingIndex; i >= 0; --i) {
                this.interceptors.get(i).postProcess(request, deferredResult, concurrentResult);
            }
        }
        catch (Throwable ex) {
            return ex;
        }
        return concurrentResult;
    }

    public void triggerAfterTimeout(RequestContext request, DeferredResult<?> deferredResult) throws Exception {
        for (DeferredResultProcessingInterceptor interceptor : this.interceptors) {
            if (deferredResult.isSetOrExpired()) {
                return;
            }
            if (interceptor.handleTimeout(request, deferredResult)) continue;
            break;
        }
    }

    public boolean triggerAfterError(RequestContext request, DeferredResult<?> deferredResult, Throwable ex) throws Exception {
        for (DeferredResultProcessingInterceptor interceptor : this.interceptors) {
            if (deferredResult.isSetOrExpired()) {
                return false;
            }
            if (interceptor.handleError(request, deferredResult, ex)) continue;
            return false;
        }
        return true;
    }

    public void triggerAfterCompletion(RequestContext request, DeferredResult<?> deferredResult) {
        for (int i = this.preProcessingIndex; i >= 0; --i) {
            try {
                this.interceptors.get(i).afterCompletion(request, deferredResult);
                continue;
            }
            catch (Throwable ex) {
                LoggerFactory.getLogger(DeferredResultInterceptorChain.class).trace("Ignoring failure in afterCompletion method", ex);
            }
        }
    }
}

