/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.concurrent.Future;
import infra.util.concurrent.FutureListener;
import infra.web.RequestContext;
import infra.web.async.DeferredResultHandler;
import infra.web.async.DeferredResultProcessingInterceptor;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DeferredResult<T>
implements FutureListener<Future<T>> {
    private static final Object RESULT_NONE = new Object();
    private static final Logger logger = LoggerFactory.getLogger(DeferredResult.class);
    @Nullable
    private final Long timeoutValue;
    private final Supplier<?> timeoutResult;
    @Nullable
    private Runnable timeoutCallback;
    @Nullable
    private Consumer<Throwable> errorCallback;
    @Nullable
    private Runnable completionCallback;
    @Nullable
    private DeferredResultHandler resultHandler;
    @Nullable
    private volatile Object result = RESULT_NONE;
    private volatile boolean expired;

    public DeferredResult() {
        this(null);
    }

    public DeferredResult(@Nullable Long timeoutValue) {
        this(timeoutValue, () -> RESULT_NONE);
    }

    public DeferredResult(@Nullable Long timeoutValue, Object timeoutResult) {
        this(timeoutValue, () -> timeoutResult);
    }

    public DeferredResult(@Nullable Long timeoutValue, Supplier<?> timeoutResult) {
        this.timeoutValue = timeoutValue;
        this.timeoutResult = timeoutResult;
    }

    public final boolean isSetOrExpired() {
        return this.result != RESULT_NONE || this.expired;
    }

    public boolean hasResult() {
        return this.result != RESULT_NONE;
    }

    @Nullable
    public Object getResult() {
        Object resultToCheck = this.result;
        return resultToCheck != RESULT_NONE ? resultToCheck : null;
    }

    @Nullable
    final Long getTimeoutValue() {
        return this.timeoutValue;
    }

    public void onTimeout(Runnable callback) {
        this.timeoutCallback = callback;
    }

    public void onError(Consumer<Throwable> callback) {
        this.errorCallback = callback;
    }

    public void onCompletion(@Nullable Runnable callback) {
        this.completionCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResultHandler(DeferredResultHandler resultHandler) {
        Object resultToHandle;
        Assert.notNull((Object)resultHandler, (String)"DeferredResultHandler is required");
        if (this.expired) {
            return;
        }
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            if (this.expired) {
                return;
            }
            resultToHandle = this.result;
            if (resultToHandle == RESULT_NONE) {
                this.resultHandler = resultHandler;
                return;
            }
        }
        try {
            resultHandler.handleResult(resultToHandle);
        }
        catch (Throwable ex) {
            logger.debug("Failed to process async result", ex);
        }
    }

    public boolean setResult(@Nullable T result) {
        return this.setResultInternal(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setResultInternal(@Nullable Object result) {
        DeferredResultHandler resultHandlerToUse;
        if (this.isSetOrExpired()) {
            return false;
        }
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            if (this.isSetOrExpired()) {
                return false;
            }
            this.result = result;
            resultHandlerToUse = this.resultHandler;
            if (resultHandlerToUse == null) {
                return true;
            }
            this.resultHandler = null;
        }
        resultHandlerToUse.handleResult(result);
        return true;
    }

    public boolean setErrorResult(@Nullable Object result) {
        return this.setResultInternal(result);
    }

    public void operationComplete(Future<T> future) {
        if (future.isSuccess()) {
            this.setResult(future.getNow());
        } else if (!future.isCancelled()) {
            this.setErrorResult(future.getCause());
        }
    }

    final DeferredResultProcessingInterceptor createInterceptor() {
        return new DeferredResultProcessingInterceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <S> boolean handleTimeout(RequestContext request, DeferredResult<S> deferredResult) {
                boolean continueProcessing = true;
                try {
                    if (DeferredResult.this.timeoutCallback != null) {
                        DeferredResult.this.timeoutCallback.run();
                    }
                }
                finally {
                    Object value = DeferredResult.this.timeoutResult.get();
                    if (value != RESULT_NONE) {
                        continueProcessing = false;
                        try {
                            DeferredResult.this.setResultInternal(value);
                        }
                        catch (Throwable ex) {
                            logger.debug("Failed to handle timeout result", ex);
                        }
                    }
                }
                return continueProcessing;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <S> boolean handleError(RequestContext request, DeferredResult<S> deferredResult, Throwable t) {
                try {
                    if (DeferredResult.this.errorCallback != null) {
                        DeferredResult.this.errorCallback.accept(t);
                    }
                }
                finally {
                    try {
                        DeferredResult.this.setResultInternal(t);
                    }
                    catch (Throwable ex) {
                        logger.debug("Failed to handle error result", ex);
                    }
                }
                return false;
            }

            public <S> void afterCompletion(RequestContext request, DeferredResult<S> deferredResult) {
                DeferredResult.this.expired = true;
                if (DeferredResult.this.completionCallback != null) {
                    DeferredResult.this.completionCallback.run();
                }
            }
        };
    }
}

