/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;
import infra.web.async.CallableProcessingInterceptor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

class CallableInterceptorChain {
    private static final Logger log = LoggerFactory.getLogger(CallableInterceptorChain.class);
    private final ArrayList<CallableProcessingInterceptor> interceptors;
    private int preProcessIndex = -1;
    @Nullable
    private volatile Future<?> taskFuture;

    public CallableInterceptorChain(ArrayList<CallableProcessingInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setTaskFuture(@Nullable Future<?> taskFuture) {
        this.taskFuture = taskFuture;
    }

    public void applyBeforeConcurrentHandling(RequestContext request, Callable<?> task) throws Exception {
        for (CallableProcessingInterceptor interceptor : this.interceptors) {
            interceptor.beforeConcurrentHandling(request, task);
        }
    }

    public void applyPreProcess(RequestContext request, Callable<?> task) throws Exception {
        for (CallableProcessingInterceptor interceptor : this.interceptors) {
            interceptor.preProcess(request, task);
            ++this.preProcessIndex;
        }
    }

    public Object applyPostProcess(RequestContext request, Callable<?> task, Object concurrentResult) {
        Object exceptionResult = null;
        for (int i = this.preProcessIndex; i >= 0; --i) {
            try {
                this.interceptors.get(i).postProcess(request, task, concurrentResult);
                continue;
            }
            catch (Throwable ex) {
                if (exceptionResult != null) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Ignoring failure in postProcess method", ex);
                    continue;
                }
                exceptionResult = ex;
            }
        }
        return exceptionResult != null ? exceptionResult : concurrentResult;
    }

    public Object triggerAfterTimeout(RequestContext request, Callable<?> task) {
        this.cancelTask();
        for (CallableProcessingInterceptor interceptor : this.interceptors) {
            try {
                Object result = interceptor.handleTimeout(request, task);
                if (result != CallableProcessingInterceptor.RESPONSE_HANDLED) {
                    if (result == CallableProcessingInterceptor.RESULT_NONE) continue;
                    return result;
                }
                break;
            }
            catch (Throwable ex) {
                return ex;
            }
        }
        return CallableProcessingInterceptor.RESULT_NONE;
    }

    private void cancelTask() {
        Future<?> future = this.taskFuture;
        if (future != null) {
            try {
                future.cancel(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Object triggerAfterError(RequestContext request, Callable<?> task, Throwable throwable) {
        this.cancelTask();
        for (CallableProcessingInterceptor interceptor : this.interceptors) {
            try {
                Object result = interceptor.handleError(request, task, throwable);
                if (result != CallableProcessingInterceptor.RESPONSE_HANDLED) {
                    if (result == CallableProcessingInterceptor.RESULT_NONE) continue;
                    return result;
                }
                break;
            }
            catch (Throwable ex) {
                return ex;
            }
        }
        return CallableProcessingInterceptor.RESULT_NONE;
    }

    public void triggerAfterCompletion(RequestContext request, Callable<?> task) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            try {
                this.interceptors.get(i).afterCompletion(request, task);
                continue;
            }
            catch (Throwable ex) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Ignoring failure in afterCompletion method", ex);
            }
        }
    }
}

