/*
 * Decompiled with CFR 0.152.
 */
package infra.web.async;

import infra.lang.Assert;
import infra.lang.Nullable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public abstract class AsyncWebRequest {
    @Nullable
    protected Long timeout;
    protected final AtomicBoolean asyncCompleted = new AtomicBoolean();
    protected final ArrayList<Runnable> timeoutHandlers = new ArrayList();
    protected final ArrayList<Runnable> completionHandlers = new ArrayList();
    protected final ArrayList<Consumer<Throwable>> exceptionHandlers = new ArrayList();

    public void setTimeout(@Nullable Long timeout) {
        Assert.state((!this.isAsyncStarted() ? 1 : 0) != 0, (String)"Cannot change the timeout with concurrent handling in progress");
        this.timeout = timeout;
    }

    public void addTimeoutHandler(Runnable timeoutHandler) {
        this.timeoutHandlers.add(timeoutHandler);
    }

    public void addErrorHandler(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
    }

    public void addCompletionHandler(Runnable runnable) {
        this.completionHandlers.add(runnable);
    }

    public boolean isAsyncComplete() {
        return this.asyncCompleted.get();
    }

    protected final void dispatchEvent(ArrayList<Runnable> handler) {
        for (Runnable runnable : handler) {
            runnable.run();
        }
    }

    public abstract void startAsync();

    public abstract boolean isAsyncStarted();

    public abstract void dispatch(@Nullable Object var1);
}

