/*
 * Decompiled with CFR 0.152.
 */
package infra.web.annotation;

import infra.aot.hint.BindingReflectionHintsRegistrar;
import infra.aot.hint.ExecutableMode;
import infra.aot.hint.MemberCategory;
import infra.aot.hint.ReflectionHints;
import infra.aot.hint.annotation.ReflectiveProcessor;
import infra.core.MethodParameter;
import infra.core.annotation.AnnotatedElementUtils;
import infra.http.HttpEntity;
import infra.lang.Nullable;
import infra.web.annotation.RequestBody;
import infra.web.annotation.RequestPart;
import infra.web.annotation.ResponseBody;
import infra.web.bind.annotation.ModelAttribute;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

class ControllerMappingReflectiveProcessor
implements ReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    ControllerMappingReflectiveProcessor() {
    }

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type = (Class)element;
            this.registerTypeHints(hints, type);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHints(hints, method);
        }
    }

    protected final BindingReflectionHintsRegistrar getBindingRegistrar() {
        return this.bindingRegistrar;
    }

    protected void registerTypeHints(ReflectionHints hints, Class<?> type) {
        hints.registerType(type, new MemberCategory[0]);
    }

    protected void registerMethodHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        for (Parameter parameter : method.getParameters()) {
            this.registerParameterTypeHints(hints, MethodParameter.forParameter((Parameter)parameter));
        }
        this.registerReturnTypeHints(hints, MethodParameter.forExecutable((Executable)method, (int)-1));
    }

    protected void registerParameterTypeHints(ReflectionHints hints, MethodParameter methodParameter) {
        Type httpEntityType;
        if (methodParameter.hasParameterAnnotation(RequestBody.class) || methodParameter.hasParameterAnnotation(ModelAttribute.class) || methodParameter.hasParameterAnnotation(RequestPart.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{methodParameter.getGenericParameterType()});
        } else if (HttpEntity.class.isAssignableFrom(methodParameter.getParameterType()) && (httpEntityType = this.getHttpEntityType(methodParameter)) != null) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{httpEntityType});
        }
    }

    protected void registerReturnTypeHints(ReflectionHints hints, MethodParameter returnTypeParameter) {
        Type httpEntityType;
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnTypeParameter.getContainingClass(), ResponseBody.class) || returnTypeParameter.hasMethodAnnotation(ResponseBody.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{returnTypeParameter.getGenericParameterType()});
        } else if (HttpEntity.class.isAssignableFrom(returnTypeParameter.getParameterType()) && (httpEntityType = this.getHttpEntityType(returnTypeParameter)) != null) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{httpEntityType});
        }
    }

    @Nullable
    private Type getHttpEntityType(MethodParameter parameter) {
        MethodParameter nestedParameter = parameter.nested();
        return nestedParameter.getNestedParameterType() == nestedParameter.getParameterType() ? null : nestedParameter.getNestedParameterType();
    }
}

