/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.core.io.Resource;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.accept.AbstractMappingContentNegotiationStrategy;
import infra.web.util.UriUtils;
import java.util.Locale;
import java.util.Map;

public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    public PathExtensionContentNegotiationStrategy() {
        this(null);
    }

    public PathExtensionContentNegotiationStrategy(@Nullable Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        this.setUseRegisteredExtensionsOnly(false);
        this.setIgnoreUnknownExtensions(true);
    }

    @Override
    @Nullable
    protected String getMediaTypeKey(RequestContext request) {
        String extension = UriUtils.extractFileExtension(request.getRequestURI());
        return StringUtils.hasText((String)extension) ? extension.toLowerCase(Locale.ROOT) : null;
    }

    @Nullable
    public MediaType getMediaTypeForResource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource is required");
        String filename = resource.getName();
        MediaType mediaType = null;
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (extension != null) {
            mediaType = this.lookupMediaType(extension);
        }
        if (mediaType == null) {
            mediaType = MediaType.fromFileName(filename);
        }
        return mediaType;
    }
}

