/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.http.MediaType;
import infra.lang.Nullable;
import infra.web.accept.MediaTypeFileExtensionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MappingMediaTypeFileExtensionResolver
implements MediaTypeFileExtensionResolver {
    private final CopyOnWriteArrayList<String> allFileExtensions = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, MediaType> mediaTypes = new ConcurrentHashMap(64);
    private final ConcurrentHashMap<MediaType, List<String>> fileExtensions = new ConcurrentHashMap(64);

    public MappingMediaTypeFileExtensionResolver(@Nullable Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            HashSet<String> allFileExtensions = new HashSet<String>(mediaTypes.size());
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String extension = entry.getKey();
                MediaType mediaType = entry.getValue();
                String lowerCaseExtension = extension.toLowerCase(Locale.ROOT);
                this.mediaTypes.put(lowerCaseExtension, mediaType);
                this.addFileExtension(mediaType, lowerCaseExtension);
                allFileExtensions.add(lowerCaseExtension);
            }
            this.allFileExtensions.addAll(allFileExtensions);
        }
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    protected List<MediaType> getAllMediaTypes() {
        return new ArrayList<MediaType>(this.mediaTypes.values());
    }

    protected void addMapping(String extension, MediaType mediaType) {
        MediaType previous = this.mediaTypes.putIfAbsent(extension, mediaType);
        if (previous == null) {
            this.addFileExtension(mediaType, extension);
            this.allFileExtensions.add(extension);
        }
    }

    private void addFileExtension(MediaType mediaType, String extension) {
        this.fileExtensions.computeIfAbsent(mediaType, key -> new CopyOnWriteArrayList()).add(extension);
    }

    @Override
    public List<String> resolveFileExtensions(MediaType mediaType) {
        List<String> fileExtensions = this.fileExtensions.get(mediaType);
        return fileExtensions != null ? fileExtensions : Collections.emptyList();
    }

    @Override
    public List<String> getAllFileExtensions() {
        return Collections.unmodifiableList(this.allFileExtensions);
    }

    @Nullable
    protected MediaType lookupMediaType(String extension) {
        return this.mediaTypes.get(extension.toLowerCase(Locale.ROOT));
    }
}

