/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.util.CollectionUtils;
import infra.util.InvalidMimeTypeException;
import infra.util.MimeTypeUtils;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationStrategy;
import java.util.List;

public class HeaderContentNegotiationStrategy
implements ContentNegotiationStrategy {
    @Override
    public List<MediaType> resolveMediaTypes(RequestContext request) throws HttpMediaTypeNotAcceptableException {
        Object headerValues = request.requestHeaders().get("Accept");
        if (headerValues == null) {
            return MEDIA_TYPE_ALL_LIST;
        }
        try {
            List mediaTypes = MediaType.parseMediaTypes((List<String>)headerValues);
            MimeTypeUtils.sortBySpecificity(mediaTypes);
            return CollectionUtils.isNotEmpty(mediaTypes) ? mediaTypes : MEDIA_TYPE_ALL_LIST;
        }
        catch (InvalidMediaTypeException | InvalidMimeTypeException ex) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header %s: %s".formatted(headerValues, ex.getMessage()));
        }
    }
}

