/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.http.MediaType;
import infra.lang.Assert;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationStrategy;
import java.util.Collections;
import java.util.List;

public class FixedContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private final List<MediaType> contentTypes;

    public FixedContentNegotiationStrategy(MediaType contentType) {
        this(Collections.singletonList(contentType));
    }

    public FixedContentNegotiationStrategy(List<MediaType> contentTypes) {
        Assert.notNull(contentTypes, (String)"'contentTypes' is required");
        this.contentTypes = Collections.unmodifiableList(contentTypes);
    }

    public List<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public List<MediaType> resolveMediaTypes(RequestContext request) {
        return this.contentTypes;
    }
}

