/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.beans.factory.FactoryBean;
import infra.beans.factory.InitializingBean;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.accept.AbstractMappingContentNegotiationStrategy;
import infra.web.accept.ContentNegotiationManager;
import infra.web.accept.ContentNegotiationStrategy;
import infra.web.accept.FixedContentNegotiationStrategy;
import infra.web.accept.HeaderContentNegotiationStrategy;
import infra.web.accept.MappingMediaTypeFileExtensionResolver;
import infra.web.accept.ParameterContentNegotiationStrategy;
import infra.web.accept.PathExtensionContentNegotiationStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class ContentNegotiationManagerFactoryBean
implements FactoryBean<ContentNegotiationManager>,
InitializingBean {
    @Nullable
    private List<ContentNegotiationStrategy> strategies;
    private boolean favorParameter = false;
    private String parameterName = "format";
    private boolean ignoreUnknownPathExtensions = true;
    private boolean favorPathExtension = false;
    private final Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
    @Nullable
    private Boolean useRegisteredExtensionsOnly;
    private boolean ignoreAcceptHeader = false;
    @Nullable
    private ContentNegotiationStrategy defaultNegotiationStrategy;
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;

    public void setStrategies(@Nullable List<ContentNegotiationStrategy> strategies) {
        this.strategies = strategies != null ? new ArrayList<ContentNegotiationStrategy>(strategies) : null;
    }

    public void setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
    }

    public void setParameterName(String parameterName) {
        Assert.notNull((Object)parameterName, (String)"parameterName is required");
        this.parameterName = parameterName;
    }

    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    public void setMediaTypes(Properties mediaTypes) {
        if (CollectionUtils.isNotEmpty((Map)mediaTypes)) {
            for (Map.Entry<Object, Object> entry : mediaTypes.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.addMediaType((String)key, MediaType.valueOf((String)value));
            }
        }
    }

    public void addMediaType(String key, MediaType mediaType) {
        this.mediaTypes.put(key.toLowerCase(Locale.ROOT), mediaType);
    }

    public void addMediaTypes(@Nullable Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String key = entry.getKey();
                MediaType value = entry.getValue();
                this.addMediaType(key, value);
            }
        }
    }

    public void setIgnoreUnknownPathExtensions(boolean ignore) {
        this.ignoreUnknownPathExtensions = ignore;
    }

    public void setUseRegisteredExtensionsOnly(boolean useRegisteredExtensionsOnly) {
        this.useRegisteredExtensionsOnly = useRegisteredExtensionsOnly;
    }

    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    public void setDefaultContentType(MediaType contentType) {
        this.defaultNegotiationStrategy = new FixedContentNegotiationStrategy(contentType);
    }

    public void setDefaultContentTypes(List<MediaType> contentTypes) {
        this.defaultNegotiationStrategy = new FixedContentNegotiationStrategy(contentTypes);
    }

    public void setDefaultContentTypeStrategy(ContentNegotiationStrategy strategy) {
        this.defaultNegotiationStrategy = strategy;
    }

    public void afterPropertiesSet() {
        this.build();
    }

    public ContentNegotiationManager build() {
        ArrayList<ContentNegotiationStrategy> strategies = new ArrayList<ContentNegotiationStrategy>();
        if (this.strategies != null) {
            strategies.addAll(this.strategies);
        } else {
            AbstractMappingContentNegotiationStrategy strategy;
            if (this.favorPathExtension) {
                strategy = new PathExtensionContentNegotiationStrategy(this.mediaTypes);
                strategy.setIgnoreUnknownExtensions(this.ignoreUnknownPathExtensions);
                if (this.useRegisteredExtensionsOnly != null) {
                    strategy.setUseRegisteredExtensionsOnly(this.useRegisteredExtensionsOnly);
                }
                strategies.add(strategy);
            }
            if (this.favorParameter) {
                strategy = new ParameterContentNegotiationStrategy(this.mediaTypes);
                ((ParameterContentNegotiationStrategy)strategy).setParameterName(this.parameterName);
                strategy.setUseRegisteredExtensionsOnly(Objects.requireNonNullElse(this.useRegisteredExtensionsOnly, true));
                strategies.add(strategy);
            }
            if (!this.ignoreAcceptHeader) {
                strategies.add(new HeaderContentNegotiationStrategy());
            }
            if (this.defaultNegotiationStrategy != null) {
                strategies.add(this.defaultNegotiationStrategy);
            }
        }
        this.contentNegotiationManager = new ContentNegotiationManager(strategies);
        if (CollectionUtils.isNotEmpty(this.mediaTypes) && !this.favorPathExtension && !this.favorParameter) {
            this.contentNegotiationManager.addFileExtensionResolvers(new MappingMediaTypeFileExtensionResolver(this.mediaTypes));
        }
        return this.contentNegotiationManager;
    }

    @Nullable
    public ContentNegotiationManager getObject() {
        return this.contentNegotiationManager;
    }

    public Class<?> getObjectType() {
        return ContentNegotiationManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

