/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationStrategy;
import infra.web.accept.HeaderContentNegotiationStrategy;
import infra.web.accept.MappingMediaTypeFileExtensionResolver;
import infra.web.accept.MediaTypeFileExtensionResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ContentNegotiationManager
implements ContentNegotiationStrategy,
MediaTypeFileExtensionResolver {
    private final ArrayList<ContentNegotiationStrategy> strategies = new ArrayList();
    private final LinkedHashSet<MediaTypeFileExtensionResolver> resolvers = new LinkedHashSet();

    public ContentNegotiationManager(ContentNegotiationStrategy ... strategies) {
        this(Arrays.asList(strategies));
    }

    public ContentNegotiationManager(Collection<ContentNegotiationStrategy> strategies) {
        Assert.notEmpty(strategies, (String)"At least one ContentNegotiationStrategy is expected");
        this.strategies.addAll(strategies);
        for (ContentNegotiationStrategy strategy : this.strategies) {
            if (!(strategy instanceof MediaTypeFileExtensionResolver)) continue;
            this.resolvers.add((MediaTypeFileExtensionResolver)((Object)strategy));
        }
    }

    public ContentNegotiationManager() {
        this(new HeaderContentNegotiationStrategy());
    }

    public List<ContentNegotiationStrategy> getStrategies() {
        return this.strategies;
    }

    @Nullable
    public <T extends ContentNegotiationStrategy> T getStrategy(Class<T> strategyType) {
        for (ContentNegotiationStrategy strategy : this.getStrategies()) {
            if (!strategyType.isInstance(strategy)) continue;
            return (T)strategy;
        }
        return null;
    }

    public void addFileExtensionResolvers(MediaTypeFileExtensionResolver ... resolvers) {
        Collections.addAll(this.resolvers, resolvers);
    }

    @Override
    public List<MediaType> resolveMediaTypes(RequestContext request) throws HttpMediaTypeNotAcceptableException {
        for (ContentNegotiationStrategy strategy : this.strategies) {
            List<MediaType> mediaTypes = strategy.resolveMediaTypes(request);
            if (mediaTypes.equals(MEDIA_TYPE_ALL_LIST)) continue;
            return mediaTypes;
        }
        return MEDIA_TYPE_ALL_LIST;
    }

    @Override
    public List<String> resolveFileExtensions(MediaType mediaType) {
        return this.doResolveExtensions(resolver -> resolver.resolveFileExtensions(mediaType));
    }

    @Override
    public List<String> getAllFileExtensions() {
        return this.doResolveExtensions(MediaTypeFileExtensionResolver::getAllFileExtensions);
    }

    private List<String> doResolveExtensions(Function<MediaTypeFileExtensionResolver, List<String>> extractor) {
        List<String> result = null;
        for (MediaTypeFileExtensionResolver resolver : this.resolvers) {
            List<String> extensions = extractor.apply(resolver);
            if (CollectionUtils.isEmpty(extensions)) continue;
            if (result == null) {
                result = new ArrayList<String>(4);
            }
            for (String extension : extensions) {
                if (((ArrayList)result).contains(extension)) continue;
                ((ArrayList)result).add(extension);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        Map<String, MediaType> result = null;
        for (MediaTypeFileExtensionResolver resolver : this.resolvers) {
            MappingMediaTypeFileExtensionResolver mediaTypeMappings;
            Map<String, MediaType> map;
            if (!(resolver instanceof MappingMediaTypeFileExtensionResolver) || CollectionUtils.isEmpty(map = (mediaTypeMappings = (MappingMediaTypeFileExtensionResolver)resolver).getMediaTypes())) continue;
            if (result == null) {
                result = new HashMap<String, MediaType>(4);
            }
            ((HashMap)result).putAll(map);
        }
        return result != null ? result : Collections.emptyMap();
    }
}

