/*
 * Decompiled with CFR 0.152.
 */
package infra.web.accept;

import infra.http.MediaType;
import infra.http.MediaTypeFactory;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationStrategy;
import infra.web.accept.MappingMediaTypeFileExtensionResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractMappingContentNegotiationStrategy
extends MappingMediaTypeFileExtensionResolver
implements ContentNegotiationStrategy {
    private boolean useRegisteredExtensionsOnly = false;
    private boolean ignoreUnknownExtensions = false;

    public AbstractMappingContentNegotiationStrategy(@Nullable Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public void setUseRegisteredExtensionsOnly(boolean useRegisteredExtensionsOnly) {
        this.useRegisteredExtensionsOnly = useRegisteredExtensionsOnly;
    }

    public boolean isUseRegisteredExtensionsOnly() {
        return this.useRegisteredExtensionsOnly;
    }

    public void setIgnoreUnknownExtensions(boolean ignoreUnknownExtensions) {
        this.ignoreUnknownExtensions = ignoreUnknownExtensions;
    }

    public boolean isIgnoreUnknownExtensions() {
        return this.ignoreUnknownExtensions;
    }

    @Override
    public List<MediaType> resolveMediaTypes(RequestContext context) throws HttpMediaTypeNotAcceptableException {
        return this.resolveMediaTypeKey(context, this.getMediaTypeKey(context));
    }

    public List<MediaType> resolveMediaTypeKey(RequestContext webRequest, @Nullable String key) throws HttpMediaTypeNotAcceptableException {
        if (StringUtils.hasText((String)key)) {
            MediaType mediaType = this.lookupMediaType(key);
            if (mediaType != null) {
                this.handleMatch(key, mediaType);
                return Collections.singletonList(mediaType);
            }
            mediaType = this.handleNoMatch(webRequest, key);
            if (mediaType != null) {
                this.addMapping(key, mediaType);
                return Collections.singletonList(mediaType);
            }
        }
        return MEDIA_TYPE_ALL_LIST;
    }

    @Nullable
    protected abstract String getMediaTypeKey(RequestContext var1);

    protected void handleMatch(String key, MediaType mediaType) {
    }

    @Nullable
    protected MediaType handleNoMatch(RequestContext request, String key) throws HttpMediaTypeNotAcceptableException {
        Optional<MediaType> mediaType;
        if (!this.isUseRegisteredExtensionsOnly() && (mediaType = MediaTypeFactory.getMediaType("file." + key)).isPresent()) {
            return mediaType.get();
        }
        if (this.isIgnoreUnknownExtensions()) {
            return null;
        }
        throw new HttpMediaTypeNotAcceptableException(this.getAllMediaTypes());
    }
}

