/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.context.support.ApplicationObjectSupport;
import infra.http.CacheControl;
import infra.http.HttpMethod;
import infra.lang.Nullable;
import infra.session.WebSessionRequiredException;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.HttpRequestMethodNotSupportedException;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class WebContentGenerator
extends ApplicationObjectSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    @Nullable
    private Set<String> supportedMethods;
    @Nullable
    private String allowHeader;
    private boolean requireSession = false;
    @Nullable
    private CacheControl cacheControl;
    private int cacheSeconds = -1;
    @Nullable
    private String[] varyByRequestHeaders;

    public WebContentGenerator() {
        this(true);
    }

    public WebContentGenerator(boolean restrictDefaultSupportedMethods) {
        if (restrictDefaultSupportedMethods) {
            this.supportedMethods = new LinkedHashSet<String>(4);
            this.supportedMethods.add(METHOD_GET);
            this.supportedMethods.add(METHOD_HEAD);
            this.supportedMethods.add(METHOD_POST);
        }
        this.initAllowHeader();
    }

    public WebContentGenerator(String ... supportedMethods) {
        this.setSupportedMethods(supportedMethods);
    }

    public final void setSupportedMethods(String ... methods) {
        this.supportedMethods = ObjectUtils.isNotEmpty((Object[])methods) ? new LinkedHashSet<String>(Arrays.asList(methods)) : null;
        this.initAllowHeader();
    }

    @Nullable
    public final String[] getSupportedMethods() {
        return this.supportedMethods != null ? StringUtils.toStringArray(this.supportedMethods) : null;
    }

    private void initAllowHeader() {
        Collection<Object> allowedMethods;
        if (this.supportedMethods == null) {
            allowedMethods = new ArrayList(HttpMethod.values().length - 1);
            for (HttpMethod method : HttpMethod.values()) {
                if (method == HttpMethod.TRACE) continue;
                allowedMethods.add(method.name());
            }
        } else if (this.supportedMethods.contains(HttpMethod.OPTIONS.name())) {
            allowedMethods = this.supportedMethods;
        } else {
            allowedMethods = new ArrayList<String>(this.supportedMethods);
            allowedMethods.add(HttpMethod.OPTIONS.name());
        }
        this.allowHeader = StringUtils.collectionToCommaDelimitedString(allowedMethods);
    }

    @Nullable
    protected String getAllowHeader() {
        return this.allowHeader;
    }

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Nullable
    public final CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public final void setVaryByRequestHeaders(String ... varyByRequestHeaders) {
        this.varyByRequestHeaders = varyByRequestHeaders;
    }

    @Nullable
    public final String[] getVaryByRequestHeaders() {
        return this.varyByRequestHeaders;
    }

    protected final void checkRequest(RequestContext request) {
        String method = request.getMethodValue();
        if (this.supportedMethods != null && !this.supportedMethods.contains(method)) {
            throw new HttpRequestMethodNotSupportedException(method, this.supportedMethods);
        }
        if (this.requireSession && RequestContextUtils.getSession(request, false) == null) {
            throw new WebSessionRequiredException("Pre-existing session required but none found");
        }
    }

    protected final void prepareResponse(RequestContext response) {
        if (this.cacheControl != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Applying default {}", (Object)this.getCacheControl());
            }
            this.applyCacheControl(response, this.cacheControl);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Applying default cacheSeconds={}", (Object)this.cacheSeconds);
            }
            this.applyCacheSeconds(response, this.cacheSeconds);
        }
        if (this.varyByRequestHeaders != null) {
            response.responseHeaders().setVary(this.getVaryRequestHeadersToAdd(response, this.varyByRequestHeaders));
        }
    }

    protected final void applyCacheControl(RequestContext response, CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            response.setHeader("Cache-Control", ccValue);
        }
    }

    protected final void applyCacheSeconds(RequestContext response, int cacheSeconds) {
        CacheControl cControl = cacheSeconds > 0 ? CacheControl.maxAge(cacheSeconds, TimeUnit.SECONDS) : (cacheSeconds == 0 ? CacheControl.noStore() : CacheControl.empty());
        this.applyCacheControl(response, cControl);
    }

    private Collection<String> getVaryRequestHeadersToAdd(RequestContext response, String[] varyByRequestHeaders) {
        if (!response.containsResponseHeader("Vary")) {
            return Arrays.asList(varyByRequestHeaders);
        }
        ArrayList<String> result = new ArrayList<String>(varyByRequestHeaders.length);
        Collections.addAll(result, varyByRequestHeaders);
        for (String existing : response.responseHeaders().getVary()) {
            if ("*".equals(existing)) {
                return Collections.emptyList();
            }
            for (String value : varyByRequestHeaders) {
                if (!value.equalsIgnoreCase(existing)) continue;
                result.remove(value);
            }
        }
        return result;
    }
}

