/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.NamedThreadLocal;
import infra.lang.Nullable;
import infra.lang.TodayStrategies;
import infra.lang.VisibleForTesting;
import infra.util.ClassUtils;
import infra.web.RequestContext;
import io.netty.util.concurrent.FastThreadLocal;

public abstract class RequestThreadLocal {
    public abstract void remove();

    @Nullable
    public abstract RequestContext get();

    public abstract void set(@Nullable RequestContext var1);

    public static RequestThreadLocal lookup() {
        RequestThreadLocal ret = (RequestThreadLocal)TodayStrategies.findFirst(RequestThreadLocal.class, null);
        if (ret == null) {
            if (ClassUtils.isPresent((String)"io.netty.util.concurrent.FastThreadLocal")) {
                return new Netty();
            }
            return new Default();
        }
        return ret;
    }

    @VisibleForTesting
    static final class Netty
    extends RequestThreadLocal {
        private final FastThreadLocal<RequestContext> threadLocal = new FastThreadLocal();

        Netty() {
        }

        @Override
        public void remove() {
            this.threadLocal.remove();
        }

        @Override
        public RequestContext get() {
            return (RequestContext)this.threadLocal.get();
        }

        @Override
        public void set(@Nullable RequestContext context) {
            this.threadLocal.set((Object)context);
        }
    }

    @VisibleForTesting
    static final class Default
    extends RequestThreadLocal {
        private final NamedThreadLocal<RequestContext> threadLocal = new NamedThreadLocal("Current Request Context");

        Default() {
        }

        @Override
        public void remove() {
            this.threadLocal.remove();
        }

        @Override
        @Nullable
        public RequestContext get() {
            return (RequestContext)this.threadLocal.get();
        }

        @Override
        public void set(@Nullable RequestContext context) {
            this.threadLocal.set((Object)context);
        }
    }
}

