/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.config.Scope;
import infra.context.ApplicationContext;
import infra.core.i18n.LocaleContext;
import infra.core.i18n.TimeZoneAwareLocaleContext;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.DecoratingRequestContext;
import infra.web.LocaleContextResolver;
import infra.web.LocaleResolver;
import infra.web.RedirectModel;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.RequestContextHolder;
import infra.web.bind.MissingRequestParameterException;
import infra.web.bind.RequestBindingException;
import infra.web.context.support.RequestScope;
import infra.web.context.support.SessionManagerDiscover;
import infra.web.context.support.SessionScope;
import infra.web.util.UriComponents;
import infra.web.util.UriComponentsBuilder;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;

public class RequestContextUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    @Nullable
    public static <T> T getBean(RequestContext request, Class<T> requiredType) {
        ApplicationContext beanFactory = request.getApplicationContext();
        if (beanFactory != null) {
            return (T)BeanFactoryUtils.find((BeanFactory)beanFactory, requiredType);
        }
        return null;
    }

    @Nullable
    public static <T> T getBean(RequestContext request, String beanName) {
        ApplicationContext beanFactory = request.getApplicationContext();
        if (beanFactory != null) {
            return (T)BeanFactoryUtils.find((BeanFactory)beanFactory, (String)beanName);
        }
        return null;
    }

    @Nullable
    public static <T> T getBean(RequestContext request, String beanName, Class<T> requiredType) {
        ApplicationContext beanFactory = request.getApplicationContext();
        if (beanFactory != null) {
            return (T)BeanFactoryUtils.find((BeanFactory)beanFactory, (String)beanName, requiredType);
        }
        return null;
    }

    @Nullable
    public static String getSessionId(RequestContext request) {
        WebSession session = RequestContextUtils.getSession(request, false);
        return session != null ? session.getId() : null;
    }

    @Nullable
    public static WebSession getSession(RequestContext request) {
        SessionManager sessionManager = RequestContextUtils.getSessionManager(request);
        if (sessionManager != null) {
            return sessionManager.getSession(request);
        }
        return null;
    }

    public static WebSession getRequiredSession(RequestContext request) {
        WebSession session = RequestContextUtils.getSession(request);
        if (session == null) {
            throw new IllegalStateException("Cannot get WebSession");
        }
        return session;
    }

    @Nullable
    public static WebSession getSession(RequestContext request, boolean create) {
        SessionManager sessionManager = RequestContextUtils.getSessionManager(request);
        if (sessionManager != null) {
            return sessionManager.getSession(request, create);
        }
        return null;
    }

    @Nullable
    public static SessionManager getSessionManager(RequestContext request) {
        return RequestContextUtils.getBean(request, "webSessionManager", SessionManager.class);
    }

    @Nullable
    public static LocaleResolver getLocaleResolver(RequestContext request) {
        return RequestContextUtils.getBean(request, "webLocaleResolver", LocaleResolver.class);
    }

    public static Locale getLocale(RequestContext request) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        return localeResolver != null ? localeResolver.resolveLocale(request) : request.getLocale();
    }

    @Nullable
    public static TimeZone getTimeZone(RequestContext request) {
        LocaleContextResolver lcr;
        LocaleContext localeContext;
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        if (localeResolver instanceof LocaleContextResolver && (localeContext = (lcr = (LocaleContextResolver)localeResolver).resolveLocaleContext(request)) instanceof TimeZoneAwareLocaleContext) {
            return ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
        }
        return null;
    }

    @Nullable
    public static RedirectModel getOutputRedirectModel(RequestContext request) {
        return RedirectModel.findOutputModel(request);
    }

    @Nullable
    public static RedirectModelManager getRedirectModelManager(RequestContext request) {
        return RequestContextUtils.getBean(request, "redirectModelManager", RedirectModelManager.class);
    }

    public static void saveRedirectModel(String location, RequestContext request) {
        RequestContextUtils.saveRedirectModel(location, request, null);
    }

    public static void saveRedirectModel(String location, RequestContext request, @Nullable RedirectModelManager manager) {
        RedirectModel redirectModel = RequestContextUtils.getOutputRedirectModel(request);
        if (CollectionUtils.isNotEmpty((Map)((Object)redirectModel))) {
            if (manager == null) {
                manager = RequestContextUtils.getRedirectModelManager(request);
            }
            if (manager != null) {
                UriComponents uriComponents = UriComponentsBuilder.fromUriString(location).build();
                redirectModel.setTargetRequestPath(uriComponents.getPath());
                redirectModel.addTargetRequestParams(uriComponents.getQueryParams());
                manager.saveRedirectModel(request, redirectModel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void parseParameters(MultiValueMap<String, String> parameterMap, String s) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            int i;
            int nameStart = 0;
            int valueStart = -1;
            int len = s.length();
            block5: for (i = 0; i < len; ++i) {
                switch (s.charAt(i)) {
                    case '=': {
                        if (nameStart == i) {
                            nameStart = i + 1;
                            break;
                        }
                        if (valueStart >= nameStart) break;
                        valueStart = i + 1;
                        break;
                    }
                    case '&': 
                    case ';': {
                        RequestContextUtils.addParam(s, nameStart, valueStart, i, parameterMap);
                        nameStart = i + 1;
                        break;
                    }
                    case '#': {
                        break block5;
                    }
                }
            }
            RequestContextUtils.addParam(s, nameStart, valueStart, i, parameterMap);
        }
    }

    private static void addParam(String s, int nameStart, int valueStart, int valueEnd, MultiValueMap<String, String> params) {
        if (nameStart < valueEnd) {
            if (valueStart <= nameStart) {
                valueStart = valueEnd + 1;
            }
            String name = s.substring(nameStart, valueStart - 1);
            if (valueStart >= valueEnd) {
                params.add((Object)name, (Object)"");
            } else {
                String value = s.substring(valueStart, valueEnd);
                params.add((Object)name, (Object)value);
            }
        }
    }

    public static void registerScopes(ConfigurableBeanFactory beanFactory) {
        beanFactory.registerResolvableDependency(WebSession.class, (Object)new WebSessionProvider((BeanFactory)beanFactory));
        beanFactory.registerScope("request", (Scope)RequestScope.instance);
        beanFactory.registerScope("session", (Scope)new SessionScope((BeanFactory)beanFactory));
        beanFactory.registerResolvableDependency(RequestContext.class, (Object)new InjectableRequestContext());
    }

    @Nullable
    public static Integer getIntParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestContextUtils.getRequiredIntParameter(request, name);
    }

    public static int getIntParameter(RequestContext request, String name, int defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return RequestContextUtils.getRequiredIntParameter(request, name);
        }
        catch (RequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredIntParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(RequestContext request, String name) throws RequestBindingException {
        return INT_PARSER.parseInt(name, request.getParameter(name));
    }

    public static int[] getRequiredIntParameters(RequestContext request, String name) throws RequestBindingException {
        return INT_PARSER.parseInts(name, request.getParameters(name));
    }

    @Nullable
    public static Long getLongParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestContextUtils.getRequiredLongParameter(request, name);
    }

    public static long getLongParameter(RequestContext request, String name, long defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return RequestContextUtils.getRequiredLongParameter(request, name);
        }
        catch (RequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredLongParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(RequestContext request, String name) throws RequestBindingException {
        return LONG_PARSER.parseLong(name, request.getParameter(name));
    }

    public static long[] getRequiredLongParameters(RequestContext request, String name) throws RequestBindingException {
        return LONG_PARSER.parseLongs(name, request.getParameters(name));
    }

    @Nullable
    public static Float getFloatParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return Float.valueOf(RequestContextUtils.getRequiredFloatParameter(request, name));
    }

    public static float getFloatParameter(RequestContext request, String name, float defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return RequestContextUtils.getRequiredFloatParameter(request, name);
        }
        catch (RequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredFloatParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(RequestContext request, String name) throws RequestBindingException {
        return FLOAT_PARSER.parseFloat(name, request.getParameter(name));
    }

    public static float[] getRequiredFloatParameters(RequestContext request, String name) throws RequestBindingException {
        return FLOAT_PARSER.parseFloats(name, request.getParameters(name));
    }

    @Nullable
    public static Double getDoubleParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestContextUtils.getRequiredDoubleParameter(request, name);
    }

    public static double getDoubleParameter(RequestContext request, String name, double defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return RequestContextUtils.getRequiredDoubleParameter(request, name);
        }
        catch (RequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredDoubleParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(RequestContext request, String name) throws RequestBindingException {
        return DOUBLE_PARSER.parseDouble(name, request.getParameter(name));
    }

    public static double[] getRequiredDoubleParameters(RequestContext request, String name) throws RequestBindingException {
        return DOUBLE_PARSER.parseDoubles(name, request.getParameters(name));
    }

    @Nullable
    public static Boolean getBooleanParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestContextUtils.getRequiredBooleanParameter(request, name);
    }

    public static boolean getBooleanParameter(RequestContext request, String name, boolean defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return RequestContextUtils.getRequiredBooleanParameter(request, name);
        }
        catch (RequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredBooleanParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(RequestContext request, String name) throws RequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(name, request.getParameter(name));
    }

    public static boolean[] getRequiredBooleanParameters(RequestContext request, String name) throws RequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(name, request.getParameters(name));
    }

    @Nullable
    public static String getStringParameter(RequestContext request, String name) throws RequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestContextUtils.getRequiredStringParameter(request, name);
    }

    public static String getStringParameter(RequestContext request, String name, String defaultVal) {
        String val = request.getParameter(name);
        return val != null ? val : defaultVal;
    }

    public static String[] getStringParameters(RequestContext request, String name) {
        try {
            return RequestContextUtils.getRequiredStringParameters(request, name);
        }
        catch (RequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(RequestContext request, String name) throws RequestBindingException {
        return STRING_PARSER.validateRequiredString(name, request.getParameter(name));
    }

    public static String[] getRequiredStringParameters(RequestContext request, String name) throws RequestBindingException {
        return STRING_PARSER.validateRequiredStrings(name, request.getParameters(name));
    }

    static final class WebSessionProvider
    implements Supplier<WebSession>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final SessionManagerDiscover sessionManagerDiscover;

        private WebSessionProvider(BeanFactory beanFactory) {
            this.sessionManagerDiscover = new SessionManagerDiscover(beanFactory);
        }

        @Override
        public WebSession get() {
            RequestContext request = RequestContextHolder.getRequired();
            return this.sessionManagerDiscover.obtain(request).getSession(request);
        }

        public String toString() {
            return "Current WebSession";
        }
    }

    private static class InjectableRequestContext
    extends DecoratingRequestContext {
        private InjectableRequestContext() {
        }

        @Override
        public RequestContext getDelegate() {
            return RequestContextHolder.getRequired();
        }

        @Override
        public String toString() {
            return "Current RequestContext";
        }
    }

    private static class IntParser
    extends ParameterParser<Integer> {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Integer doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, @Nullable String parameter) throws RequestBindingException {
            return (Integer)this.parse(name, parameter);
        }

        public int[] parseInts(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseInt(name, values[i]);
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser<Long> {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Long doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, @Nullable String parameter) throws RequestBindingException {
            return (Long)this.parse(name, parameter);
        }

        public long[] parseLongs(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseLong(name, values[i]);
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser<Float> {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Float doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, @Nullable String parameter) throws RequestBindingException {
            return ((Float)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseFloat(name, values[i]);
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser<Double> {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Double doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name, @Nullable String parameter) throws RequestBindingException {
            return (Double)this.parse(name, parameter);
        }

        public double[] parseDoubles(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseDouble(name, values[i]);
            }
            return parameters;
        }
    }

    private static class BooleanParser
    extends ParameterParser<Boolean> {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Boolean doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1");
        }

        public boolean parseBoolean(String name, @Nullable String parameter) throws RequestBindingException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseBoolean(name, values[i]);
            }
            return parameters;
        }
    }

    private static class StringParser
    extends ParameterParser<String> {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected String doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, @Nullable String value) throws RequestBindingException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, @Nullable String[] values) throws RequestBindingException {
            this.validateRequiredParameter(name, values);
            for (String value : values) {
                this.validateRequiredParameter(name, value);
            }
            return values;
        }
    }

    private static abstract class ParameterParser<T> {
        private ParameterParser() {
        }

        protected final T parse(String name, @Nullable String parameter) throws RequestBindingException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new RequestBindingException("Required %s parameter '%s' with value of '%s' is not a valid number".formatted(this.getType(), name, parameter), ex);
            }
        }

        protected final void validateRequiredParameter(String name, @Nullable Object parameter) throws RequestBindingException {
            if (parameter == null) {
                throw new MissingRequestParameterException(name, this.getType());
            }
        }

        protected abstract String getType();

        protected abstract T doParse(String var1) throws NumberFormatException;
    }
}

