/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.RequestThreadLocal;

public abstract class RequestContextHolder {
    private static final RequestThreadLocal contextHolder = RequestThreadLocal.lookup();

    public static void cleanup() {
        contextHolder.remove();
    }

    public static void set(RequestContext requestContext) {
        contextHolder.set(requestContext);
    }

    @Nullable
    public static RequestContext get() {
        return contextHolder.get();
    }

    public static RequestContext getRequired() {
        RequestContext context = contextHolder.get();
        if (context == null) {
            throw new IllegalStateException("No RequestContext set");
        }
        return context;
    }
}

