/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.context.ApplicationContext;
import infra.core.AttributeAccessor;
import infra.core.AttributeAccessorSupport;
import infra.core.Conventions;
import infra.core.io.InputStreamSource;
import infra.core.io.OutputStreamSource;
import infra.http.DefaultHttpHeaders;
import infra.http.ETag;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.server.RequestPath;
import infra.http.server.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.NullValue;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.BindingContext;
import infra.web.DispatcherHandler;
import infra.web.HandlerMatchingMetadata;
import infra.web.RedirectModel;
import infra.web.RedirectModelManager;
import infra.web.RequestContextUtils;
import infra.web.async.AsyncWebRequest;
import infra.web.async.WebAsyncManager;
import infra.web.async.WebAsyncManagerFactory;
import infra.web.multipart.MultipartRequest;
import infra.web.util.UriComponents;
import infra.web.util.UriComponentsBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public abstract class RequestContext
extends AttributeAccessorSupport
implements InputStreamSource,
OutputStreamSource,
HttpInputMessage,
HttpRequest,
AttributeAccessor {
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_SESSION = "session";
    private static final List<String> SAFE_METHODS = List.of("GET", "HEAD");
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final HttpCookie[] EMPTY_COOKIES = new HttpCookie[0];
    @Nullable
    protected HttpCookie[] cookies;
    @Nullable
    protected PrintWriter writer;
    @Nullable
    protected BufferedReader reader;
    @Nullable
    protected InputStream inputStream;
    @Nullable
    protected OutputStream outputStream;
    @Nullable
    protected HttpHeaders requestHeaders;
    @Nullable
    protected HttpHeaders responseHeaders;
    @Nullable
    protected String requestURI;
    @Nullable
    protected RequestPath requestPath;
    @Nullable
    protected MultiValueMap<String, String> parameters;
    @Nullable
    protected String queryString;
    @Nullable
    protected ArrayList<HttpCookie> responseCookies;
    @Nullable
    protected URI uri;
    @Nullable
    protected HttpMethod httpMethod;
    @Nullable
    protected Locale locale;
    @Nullable
    protected String responseContentType;
    @Nullable
    protected MultipartRequest multipartRequest;
    @Nullable
    protected AsyncWebRequest asyncRequest;
    @Nullable
    protected WebAsyncManager webAsyncManager;
    protected boolean notModified = false;
    @Nullable
    private HandlerMatchingMetadata matchingMetadata;
    @Nullable
    protected BindingContext bindingContext;
    @Nullable
    protected Object redirectModel;
    @Nullable
    protected Boolean multipartFlag;
    @Nullable
    protected Boolean preFlightRequestFlag;
    @Nullable
    protected Boolean corsRequestFlag;
    @Nullable
    protected LinkedHashMap<String, Runnable> destructionCallbacks;
    private long requestCompletedTimeMillis;
    protected final DispatcherHandler dispatcherHandler;
    protected final ApplicationContext applicationContext;

    protected RequestContext(ApplicationContext context, DispatcherHandler dispatcherHandler) {
        this.applicationContext = context;
        this.dispatcherHandler = dispatcherHandler;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public abstract long getRequestTimeMillis();

    public final long getRequestProcessingTime() {
        long requestCompletedTimeMillis = this.requestCompletedTimeMillis;
        if (requestCompletedTimeMillis > 0L) {
            return requestCompletedTimeMillis - this.getRequestTimeMillis();
        }
        return System.currentTimeMillis() - this.getRequestTimeMillis();
    }

    public abstract String getScheme();

    public abstract String getServerName();

    public abstract int getServerPort();

    @Override
    public URI getURI() {
        if (this.uri == null) {
            String urlString = null;
            boolean hasQuery = false;
            try {
                StringBuilder url = new StringBuilder(this.getRequestURL());
                String query = this.getQueryString();
                hasQuery = StringUtils.hasText((String)query);
                if (hasQuery) {
                    url.append('?').append(query);
                }
                urlString = url.toString();
                this.uri = new URI(urlString);
            }
            catch (URISyntaxException ex) {
                if (!hasQuery) {
                    throw new IllegalStateException("Could not resolve RequestContext as URI: " + urlString, ex);
                }
                try {
                    urlString = this.getRequestURL();
                    this.uri = new URI(urlString);
                }
                catch (URISyntaxException ex2) {
                    throw new IllegalStateException("Could not resolve RequestContext as URI: " + urlString, ex2);
                }
            }
        }
        return this.uri;
    }

    public String getRequestURI() {
        String requestURI = this.requestURI;
        if (requestURI == null) {
            this.requestURI = requestURI = this.doGetRequestURI();
        }
        return requestURI;
    }

    public RequestPath getRequestPath() {
        RequestPath requestPath = this.requestPath;
        if (requestPath == null) {
            this.requestPath = requestPath = this.doGetRequestPath();
        }
        return requestPath;
    }

    protected RequestPath doGetRequestPath() {
        return RequestPath.parse(this.getRequestURI(), null);
    }

    public void setMatchingMetadata(@Nullable HandlerMatchingMetadata handlerMatchingMetadata) {
        this.matchingMetadata = handlerMatchingMetadata;
    }

    @Nullable
    public HandlerMatchingMetadata getMatchingMetadata() {
        return this.matchingMetadata;
    }

    public HandlerMatchingMetadata matchingMetadata() {
        HandlerMatchingMetadata matchingMetadata = this.matchingMetadata;
        Assert.state((matchingMetadata != null ? 1 : 0) != 0, (String)"HandlerMatchingMetadata is required");
        return matchingMetadata;
    }

    public boolean hasMatchingMetadata() {
        return this.matchingMetadata != null;
    }

    protected abstract String doGetRequestURI();

    public String getRequestURL() {
        String host = this.requestHeaders().getFirst("Host");
        if (host == null) {
            host = "localhost";
        }
        return this.getScheme() + "://" + host + StringUtils.prependLeadingSlash((String)this.getRequestURI());
    }

    public String getQueryString() {
        String queryString = this.queryString;
        if (queryString == null) {
            this.queryString = queryString = this.doGetQueryString();
        }
        return queryString;
    }

    protected abstract String doGetQueryString();

    public HttpCookie[] getCookies() {
        HttpCookie[] cookies = this.cookies;
        if (cookies == null) {
            cookies = this.doGetCookies();
            this.cookies = cookies;
        }
        return cookies;
    }

    protected abstract HttpCookie[] doGetCookies();

    @Nullable
    public HttpCookie getCookie(String name) {
        for (HttpCookie cookie : this.getCookies()) {
            if (!Objects.equals(name, cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void addCookie(HttpCookie cookie) {
        this.responseCookies().add(cookie);
    }

    public void addCookie(String name, @Nullable String value) {
        this.addCookie(new HttpCookie(name, value));
    }

    @Nullable
    public List<HttpCookie> removeCookie(String name) {
        if (this.responseCookies != null) {
            ArrayList<HttpCookie> toRemove = new ArrayList<HttpCookie>(2);
            for (HttpCookie responseCookie : this.responseCookies) {
                if (!Objects.equals(name, responseCookie.getName())) continue;
                toRemove.add(responseCookie);
            }
            this.responseCookies.removeAll(toRemove);
            return toRemove;
        }
        return null;
    }

    public boolean hasResponseCookie() {
        return this.responseCookies != null;
    }

    public ArrayList<HttpCookie> responseCookies() {
        ArrayList<HttpCookie> responseCookies = this.responseCookies;
        if (responseCookies == null) {
            this.responseCookies = responseCookies = new ArrayList();
        }
        return responseCookies;
    }

    public MultiValueMap<String, String> getParameters() {
        MultiValueMap<String, String> parameters = this.parameters;
        if (parameters == null) {
            this.parameters = parameters = this.doGetParameters();
        }
        return parameters;
    }

    protected abstract MultiValueMap<String, String> doGetParameters();

    public Iterable<String> getParameterNames() {
        MultiValueMap<String, String> parameters = this.getParameters();
        if (CollectionUtils.isEmpty(parameters)) {
            return Collections.emptyList();
        }
        return new LinkedHashSet<String>(parameters.keySet());
    }

    @Nullable
    public String[] getParameters(String name) {
        MultiValueMap<String, String> parameters = this.getParameters();
        if (CollectionUtils.isEmpty(parameters)) {
            return null;
        }
        List list = (List)parameters.get((Object)name);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return StringUtils.toStringArray((Collection)list);
    }

    @Nullable
    public String getParameter(String name) {
        Object[] parameters = this.getParameters(name);
        if (ObjectUtils.isNotEmpty((Object[])parameters)) {
            return parameters[0];
        }
        return null;
    }

    @Override
    public String getMethodValue() {
        return this.getMethod().name();
    }

    @Override
    public HttpMethod getMethod() {
        HttpMethod httpMethod = this.httpMethod;
        if (httpMethod == null) {
            this.httpMethod = httpMethod = HttpMethod.valueOf(this.doGetMethod());
        }
        return httpMethod;
    }

    protected abstract String doGetMethod();

    public abstract String getRemoteAddress();

    public abstract long getContentLength();

    @Override
    public InputStream getBody() throws IOException {
        return this.getInputStream();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.requestHeaders();
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.inputStream;
        if (inputStream == null) {
            this.inputStream = inputStream = this.doGetInputStream();
        }
        return inputStream;
    }

    protected abstract InputStream doGetInputStream() throws IOException;

    public BufferedReader getReader() throws IOException {
        BufferedReader reader = this.reader;
        if (reader == null) {
            this.reader = reader = this.doGetReader();
        }
        return reader;
    }

    protected BufferedReader doGetReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), Constant.DEFAULT_CHARSET));
    }

    public boolean isMultipart() {
        Boolean multipartFlag = this.multipartFlag;
        if (multipartFlag == null) {
            HttpMethod method = this.getMethod();
            multipartFlag = method == HttpMethod.GET || method == HttpMethod.HEAD ? Boolean.valueOf(false) : Boolean.valueOf(StringUtils.startsWithIgnoreCase((String)this.getContentType(), (String)"multipart/"));
            this.multipartFlag = multipartFlag;
        }
        return multipartFlag;
    }

    public MultipartRequest getMultipartRequest() {
        MultipartRequest multipartRequest = this.multipartRequest;
        if (multipartRequest == null) {
            this.multipartRequest = multipartRequest = this.createMultipartRequest();
        }
        return multipartRequest;
    }

    protected abstract MultipartRequest createMultipartRequest();

    public boolean isConcurrentHandlingStarted() {
        return this.asyncRequest != null && this.asyncRequest.isAsyncStarted();
    }

    public AsyncWebRequest getAsyncWebRequest() {
        AsyncWebRequest asyncRequest = this.asyncRequest;
        if (asyncRequest == null) {
            this.asyncRequest = asyncRequest = this.createAsyncWebRequest();
        }
        return asyncRequest;
    }

    protected abstract AsyncWebRequest createAsyncWebRequest();

    public WebAsyncManager getAsyncManager() {
        WebAsyncManager webAsyncManager = this.webAsyncManager;
        if (webAsyncManager == null) {
            this.webAsyncManager = webAsyncManager = this.createWebAsyncManager();
        }
        return webAsyncManager;
    }

    private WebAsyncManager createWebAsyncManager() {
        DispatcherHandler dispatcherHandler = this.dispatcherHandler;
        if (dispatcherHandler == null && this.getApplicationContext() != null) {
            dispatcherHandler = (DispatcherHandler)BeanFactoryUtils.find((BeanFactory)this.getApplicationContext(), DispatcherHandler.class);
        }
        WebAsyncManagerFactory factory = null;
        if (dispatcherHandler != null) {
            factory = dispatcherHandler.webAsyncManagerFactory;
        }
        if (factory == null && this.getApplicationContext() != null) {
            factory = (WebAsyncManagerFactory)BeanFactoryUtils.find((BeanFactory)this.getApplicationContext(), WebAsyncManagerFactory.class);
        }
        if (factory == null) {
            factory = new WebAsyncManagerFactory();
        }
        return factory.getWebAsyncManager(this);
    }

    public void requestCompleted() {
        this.requestCompleted(null);
    }

    public void requestCompleted(@Nullable Throwable notHandled) {
        this.requestCompletedTimeMillis = System.currentTimeMillis();
        if (this.multipartRequest != null) {
            this.multipartRequest.cleanup();
        }
        this.requestCompletedInternal(notHandled);
        LinkedHashMap<String, Runnable> callbacks = this.destructionCallbacks;
        if (callbacks != null) {
            this.destructionCallbacks = null;
            for (Runnable runnable : callbacks.values()) {
                runnable.run();
            }
            callbacks.clear();
        }
    }

    protected void requestCompletedInternal(@Nullable Throwable notHandled) {
    }

    public final void registerDestructionCallback(Runnable callback) {
        Assert.notNull((Object)callback, (String)"Destruction Callback is required");
        String variableName = Conventions.getVariableName((Object)callback);
        this.registerDestructionCallback(variableName, callback);
    }

    public final void registerDestructionCallback(String name, Runnable callback) {
        Assert.notNull((Object)name, (String)"Name is required");
        Assert.notNull((Object)callback, (String)"Destruction Callback is required");
        if (this.destructionCallbacks == null) {
            this.destructionCallbacks = new LinkedHashMap(8);
        }
        this.destructionCallbacks.put(name, callback);
    }

    public final void removeDestructionCallback(String name) {
        Assert.notNull((Object)name, (String)"Name is required");
        if (this.destructionCallbacks != null) {
            this.destructionCallbacks.remove(name);
        }
    }

    public boolean isPreFlightRequest() {
        Boolean preFlightRequestFlag = this.preFlightRequestFlag;
        if (preFlightRequestFlag == null) {
            HttpHeaders httpHeaders;
            preFlightRequestFlag = HttpMethod.OPTIONS == this.getMethod() ? Boolean.valueOf((httpHeaders = this.requestHeaders()).getFirst("Origin") != null && httpHeaders.getFirst("Access-Control-Request-Method") != null) : Boolean.valueOf(false);
            this.preFlightRequestFlag = preFlightRequestFlag;
        }
        return preFlightRequestFlag;
    }

    public boolean isCorsRequest() {
        Boolean corsRequestFlag = this.corsRequestFlag;
        if (corsRequestFlag == null) {
            String origin = this.requestHeaders().getFirst("Origin");
            if (origin == null) {
                corsRequestFlag = false;
            } else {
                UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
                String scheme = this.getScheme();
                String host = this.getServerName();
                int port = this.getServerPort();
                corsRequestFlag = !ObjectUtils.nullSafeEquals((Object)scheme, (Object)originUrl.getScheme()) || !ObjectUtils.nullSafeEquals((Object)host, (Object)originUrl.getHost()) || RequestContext.getPort(scheme, port) != RequestContext.getPort(originUrl.getScheme(), originUrl.getPort());
            }
        }
        return corsRequestFlag;
    }

    protected static int getPort(@Nullable String scheme, int port) {
        if (port == -1) {
            if ("http".equals(scheme) || "ws".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme) || "wss".equals(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    @Nullable
    public abstract String getContentType();

    public HttpHeaders requestHeaders() {
        HttpHeaders requestHeaders = this.requestHeaders;
        if (requestHeaders == null) {
            this.requestHeaders = requestHeaders = this.createRequestHeaders();
        }
        return requestHeaders;
    }

    protected abstract HttpHeaders createRequestHeaders();

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.doGetLocale();
        }
        return this.locale;
    }

    protected Locale doGetLocale() {
        List<Locale> locales = this.requestHeaders().getAcceptLanguageAsLocales();
        Locale locale = (Locale)CollectionUtils.firstElement(locales);
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public boolean checkNotModified(long lastModifiedTimestamp) {
        return this.checkNotModified(null, lastModifiedTimestamp);
    }

    public boolean checkNotModified(String etag) {
        return this.checkNotModified(etag, -1L);
    }

    public boolean checkNotModified(@Nullable String eTag, long lastModifiedTimestamp) {
        if (this.notModified || HttpStatus.OK.value() != this.getStatus()) {
            return this.notModified;
        }
        if (this.validateIfMatch(eTag)) {
            this.updateResponseStateChanging(eTag, lastModifiedTimestamp);
            return this.notModified;
        }
        if (this.validateIfUnmodifiedSince(lastModifiedTimestamp)) {
            this.updateResponseStateChanging(eTag, lastModifiedTimestamp);
            return this.notModified;
        }
        if (!this.validateIfNoneMatch(eTag)) {
            this.validateIfModifiedSince(lastModifiedTimestamp);
        }
        this.updateResponseIdempotent(eTag, lastModifiedTimestamp);
        return this.notModified;
    }

    private boolean validateIfMatch(@Nullable String eTag) {
        if (SAFE_METHODS.contains(this.getMethodValue())) {
            return false;
        }
        Object ifMatchHeaders = this.requestHeaders().get("If-Match");
        if (CollectionUtils.isEmpty((Collection)ifMatchHeaders)) {
            return false;
        }
        this.notModified = this.matchRequestedETags((List<String>)ifMatchHeaders, eTag, false);
        return true;
    }

    private boolean validateIfNoneMatch(@Nullable String eTag) {
        Object ifNoneMatchHeaders = this.requestHeaders().get("If-None-Match");
        if (CollectionUtils.isEmpty((Collection)ifNoneMatchHeaders)) {
            return false;
        }
        this.notModified = !this.matchRequestedETags((List<String>)ifNoneMatchHeaders, eTag, true);
        return true;
    }

    private boolean matchRequestedETags(List<String> requestedETags, @Nullable String tag, boolean weakCompare) {
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            ETag eTag = ETag.create(tag);
            boolean isNotSafeMethod = !SAFE_METHODS.contains(this.getMethodValue());
            for (String requestedETagString : requestedETags) {
                for (ETag requestedETag : ETag.parse(requestedETagString)) {
                    if (requestedETag.isWildcard() && isNotSafeMethod) {
                        return false;
                    }
                    if (!requestedETag.compare(eTag, !weakCompare)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void updateResponseStateChanging(@Nullable String eTag, long lastModifiedTimestamp) {
        if (this.notModified) {
            this.setStatus(HttpStatus.PRECONDITION_FAILED.value());
        } else {
            this.addCachingResponseHeaders(eTag, lastModifiedTimestamp);
        }
    }

    private boolean validateIfUnmodifiedSince(long lastModifiedTimestamp) {
        if (lastModifiedTimestamp < 0L) {
            return false;
        }
        long ifUnmodifiedSince = this.parseDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince == -1L) {
            return false;
        }
        this.notModified = ifUnmodifiedSince < lastModifiedTimestamp / 1000L * 1000L;
        return true;
    }

    private void validateIfModifiedSince(long lastModifiedTimestamp) {
        if (lastModifiedTimestamp < 0L) {
            return;
        }
        long ifModifiedSince = this.parseDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L) {
            this.notModified = ifModifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
        }
    }

    private void updateResponseIdempotent(@Nullable String eTag, long lastModifiedTimestamp) {
        boolean isHttpGetOrHead = SAFE_METHODS.contains(this.getMethodValue());
        if (this.notModified) {
            this.setStatus(isHttpGetOrHead ? HttpStatus.NOT_MODIFIED.value() : HttpStatus.PRECONDITION_FAILED.value());
        }
        if (isHttpGetOrHead) {
            HttpHeaders httpHeaders = this.responseHeaders();
            if (lastModifiedTimestamp > 0L && this.parseDateValue(httpHeaders.getFirst("Last-Modified")) == -1L) {
                httpHeaders.setDate("Last-Modified", lastModifiedTimestamp);
            }
            if (StringUtils.isNotEmpty((CharSequence)eTag) && httpHeaders.get("ETag") == null) {
                httpHeaders.setOrRemove("ETag", ETag.quoteETagIfNecessary(eTag));
            }
        }
    }

    private void addCachingResponseHeaders(@Nullable String eTag, long lastModifiedTimestamp) {
        if (SAFE_METHODS.contains(this.getMethodValue())) {
            HttpHeaders httpHeaders = this.responseHeaders();
            if (lastModifiedTimestamp > 0L && this.parseDateValue(httpHeaders.getFirst("Last-Modified")) == -1L) {
                httpHeaders.setLastModified(lastModifiedTimestamp);
            }
            if (StringUtils.isNotEmpty((CharSequence)eTag) && httpHeaders.get("ETag") == null) {
                httpHeaders.setOrRemove("ETag", ETag.quoteETagIfNecessary(eTag));
            }
        }
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    private long parseDateHeader(String headerName) {
        long dateValue;
        block5: {
            dateValue = -1L;
            HttpHeaders httpHeaders = this.requestHeaders();
            try {
                dateValue = httpHeaders.getFirstDate(headerName);
            }
            catch (IllegalArgumentException ex) {
                String headerValue = httpHeaders.getFirst(headerName);
                if (headerValue == null) break block5;
                int separatorIndex = headerValue.indexOf(59);
                if (separatorIndex != -1) {
                    String datePart = headerValue.substring(0, separatorIndex);
                    dateValue = this.parseDateValue(datePart);
                }
                try {
                    return Long.parseLong(headerValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return dateValue;
    }

    private long parseDateValue(@Nullable String headerValue) {
        if (headerValue == null) {
            return -1L;
        }
        if (headerValue.length() >= 3) {
            for (String dateFormat : DATE_FORMATS) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
                simpleDateFormat.setTimeZone(GMT);
                try {
                    return simpleDateFormat.parse(headerValue).getTime();
                }
                catch (ParseException parseException) {
                }
            }
        }
        return -1L;
    }

    public void setBinding(@Nullable BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public boolean hasBinding() {
        return this.bindingContext != null;
    }

    @Nullable
    public BindingContext getBinding() {
        return this.bindingContext;
    }

    public BindingContext binding() {
        BindingContext bindingContext = this.bindingContext;
        Assert.state((bindingContext != null ? 1 : 0) != 0, (String)"BindingContext is required");
        return bindingContext;
    }

    @Nullable
    public RedirectModel getInputRedirectModel() {
        return this.getInputRedirectModel(null);
    }

    @Nullable
    public RedirectModel getInputRedirectModel(@Nullable RedirectModelManager manager) {
        RedirectModel redirectModel;
        Object object = this.redirectModel;
        if (object instanceof RedirectModel) {
            RedirectModel ret = (RedirectModel)object;
            return ret;
        }
        if (this.redirectModel == NullValue.INSTANCE) {
            return null;
        }
        if (manager == null) {
            manager = RequestContextUtils.getRedirectModelManager(this);
        }
        if (manager != null && (redirectModel = manager.retrieveAndUpdate(this)) != null) {
            this.redirectModel = redirectModel;
            return redirectModel;
        }
        Object attribute = this.getAttribute(RedirectModel.INPUT_ATTRIBUTE);
        if (attribute instanceof RedirectModel) {
            RedirectModel ret = (RedirectModel)attribute;
            this.redirectModel = ret;
            return ret;
        }
        this.redirectModel = NullValue.INSTANCE;
        return null;
    }

    public void setContentLength(long length) {
        this.responseHeaders().setContentLength(length);
    }

    public abstract boolean isCommitted();

    public void reset() {
        if (this.responseHeaders != null) {
            this.responseHeaders.clear();
        }
    }

    public abstract void sendRedirect(String var1) throws IOException;

    public abstract void setStatus(int var1);

    public void setStatus(HttpStatusCode status) {
        this.setStatus(status.value());
    }

    public abstract int getStatus();

    public void sendError(HttpStatusCode code) throws IOException {
        this.sendError(code.value());
    }

    public void sendError(HttpStatusCode code, @Nullable String msg) throws IOException {
        this.sendError(code.value(), msg);
    }

    public abstract void sendError(int var1) throws IOException;

    public abstract void sendError(int var1, @Nullable String var2) throws IOException;

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            this.outputStream = outputStream = this.doGetOutputStream();
        }
        return outputStream;
    }

    protected abstract OutputStream doGetOutputStream() throws IOException;

    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = this.writer;
        if (writer == null) {
            this.writer = writer = this.doGetWriter();
        }
        return writer;
    }

    protected PrintWriter doGetWriter() throws IOException {
        return new PrintWriter(this.getOutputStream(), true);
    }

    public void setContentType(@Nullable String contentType) {
        this.responseContentType = contentType;
        this.setHeader("Content-Type", contentType);
    }

    public void setContentType(@Nullable MediaType contentType) {
        this.setContentType(contentType == null ? null : contentType.toString());
    }

    @Nullable
    public String getResponseContentType() {
        if (this.responseContentType == null && this.responseHeaders != null) {
            return this.responseHeaders.getFirst("Content-Type");
        }
        return this.responseContentType;
    }

    public void setHeader(String name, @Nullable String value) {
        this.responseHeaders().setOrRemove(name, value);
    }

    public void addHeader(String name, @Nullable String value) {
        this.responseHeaders().add(name, value);
    }

    public void removeHeader(String name) {
        if (this.responseHeaders != null) {
            this.responseHeaders.remove(name);
        }
    }

    public boolean containsResponseHeader(String name) {
        return this.responseHeaders != null && this.responseHeaders.containsKey(name);
    }

    public HttpHeaders responseHeaders() {
        HttpHeaders responseHeaders = this.responseHeaders;
        if (responseHeaders == null) {
            this.responseHeaders = responseHeaders = this.createResponseHeaders();
        }
        return responseHeaders;
    }

    public void mergeToResponse(HttpHeaders headers) {
        this.responseHeaders().addAll((Map)((Object)headers));
    }

    protected HttpHeaders createResponseHeaders() {
        return new DefaultHttpHeaders();
    }

    public ServerHttpResponse asHttpOutputMessage() {
        return new RequestContextHttpOutputMessage();
    }

    public abstract <T> T nativeRequest();

    public void flush() throws IOException {
        this.writeHeaders();
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    protected void writeHeaders() {
    }

    public String toString() {
        String url = URLDecoder.decode(this.getRequestURL(), StandardCharsets.UTF_8);
        return this.getMethodValue() + " " + url;
    }

    final class RequestContextHttpOutputMessage
    implements ServerHttpResponse {
        RequestContextHttpOutputMessage() {
        }

        @Override
        public void setStatusCode(HttpStatusCode status) {
            RequestContext.this.setStatus(status);
        }

        @Override
        public void flush() throws IOException {
            RequestContext.this.flush();
        }

        @Override
        public void close() {
            RequestContext.this.writeHeaders();
        }

        @Override
        public OutputStream getBody() throws IOException {
            return RequestContext.this.getOutputStream();
        }

        @Override
        public HttpHeaders getHeaders() {
            return RequestContext.this.responseHeaders();
        }

        @Override
        public void setContentType(@Nullable MediaType mediaType) {
            RequestContext.this.setContentType(mediaType);
        }
    }
}

