/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.AttributeAccessor;
import infra.core.Conventions;
import infra.lang.Nullable;
import infra.ui.ModelMap;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RedirectModel
extends ModelMap
implements Serializable,
Comparable<RedirectModel> {
    private static final long serialVersionUID = 1L;
    public static final String INPUT_ATTRIBUTE = Conventions.getQualifiedAttributeName(RedirectModel.class, (String)"INPUT");
    public static final String OUTPUT_ATTRIBUTE = Conventions.getQualifiedAttributeName(RedirectModel.class, (String)"OUTPUT");
    @Nullable
    private String targetRequestPath;
    private final MultiValueMap<String, String> targetRequestParams = MultiValueMap.forLinkedHashMap((int)3);
    private long expirationTime = -1L;

    public RedirectModel() {
    }

    public RedirectModel(String attributeName, @Nullable Object attributeValue) {
        this.setAttribute(attributeName, attributeValue);
    }

    public void setTargetRequestPath(@Nullable String path) {
        this.targetRequestPath = path;
    }

    @Nullable
    public String getTargetRequestPath() {
        return this.targetRequestPath;
    }

    public void addTargetRequestParams(@Nullable MultiValueMap<String, String> params) {
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    this.addTargetRequestParam(key, value);
                }
            }
        }
    }

    public void addTargetRequestParam(String name, String value) {
        if (StringUtils.hasText((String)name) && StringUtils.hasText((String)value)) {
            this.targetRequestParams.add((Object)name, (Object)value);
        }
    }

    public MultiValueMap<String, String> getTargetRequestParams() {
        return this.targetRequestParams;
    }

    public void startExpirationPeriod(int timeToLive) {
        this.expirationTime = System.currentTimeMillis() + (long)timeToLive * 1000L;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return this.expirationTime != -1L && System.currentTimeMillis() > this.expirationTime;
    }

    @Override
    public int compareTo(RedirectModel other) {
        int otherUrlPath;
        int thisUrlPath = this.targetRequestPath != null ? 1 : 0;
        int n = otherUrlPath = other.targetRequestPath != null ? 1 : 0;
        if (thisUrlPath != otherUrlPath) {
            return otherUrlPath - thisUrlPath;
        }
        return other.targetRequestParams.size() - this.targetRequestParams.size();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RedirectModel)) {
            return false;
        }
        RedirectModel model = (RedirectModel)other;
        return super.equals((Object)model) && Objects.equals(this.targetRequestPath, model.targetRequestPath) && this.targetRequestParams.equals(model.targetRequestParams);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.targetRequestPath);
        result = 31 * result + this.targetRequestParams.hashCode();
        return result;
    }

    public String toString() {
        return "RedirectModel [attributes=" + super.toString() + ", targetRequestPath=" + this.targetRequestPath + ", targetRequestParams=" + this.targetRequestParams + "]";
    }

    @Nullable
    public static RedirectModel findOutputModel(AttributeAccessor attributeAccessor) {
        Object attribute = attributeAccessor.getAttribute(OUTPUT_ATTRIBUTE);
        if (attribute instanceof RedirectModel) {
            return (RedirectModel)attribute;
        }
        return null;
    }
}

